/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaNullMethodArgumentIndex
extends ScalarIndexExtension<MethodCallData> {
    public static final ID<MethodCallData, Void> INDEX_ID = ID.create((String)"java.null.method.argument");
    private final boolean myOfflineMode = ApplicationManager.getApplication().isCommandLine() && !ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    public ID<MethodCallData, Void> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<MethodCallData, Void, FileContent> getIndexer() {
        return inputData -> {
            if (this.myOfflineMode) {
                return Collections.emptyMap();
            }
            THashMap result = new THashMap();
            TokenList tokens = JavaParserUtil.obtainTokens(inputData.getPsiFile());
            for (int i = 0; i < tokens.getTokenCount(); ++i) {
                MethodCallData data;
                if (!tokens.hasType(i, JavaTokenType.NULL_KEYWORD) || (data = JavaNullMethodArgumentIndex.findCallData(tokens, i)) == null) continue;
                result.put(data, null);
            }
            return result;
        };
    }

    @Nullable
    private static MethodCallData findCallData(TokenList tokens, int nullIndex) {
        if (!tokens.hasType(tokens.forwardWhile(nullIndex + 1, JavaParserUtil.WS_COMMENTS), new IElementType[]{JavaTokenType.RPARENTH, JavaTokenType.COMMA})) {
            return null;
        }
        int i = tokens.backWhile(nullIndex - 1, JavaParserUtil.WS_COMMENTS);
        if (!tokens.hasType(i, new IElementType[]{JavaTokenType.LPARENTH, JavaTokenType.COMMA})) {
            return null;
        }
        int commaCount = 0;
        while (!tokens.hasType(i, new IElementType[]{null, JavaTokenType.SEMICOLON, JavaTokenType.EQ, JavaTokenType.RBRACE})) {
            IElementType type2 = tokens.getTokenType(i);
            if (type2 == JavaTokenType.COMMA) {
                ++commaCount;
            } else if (type2 == JavaTokenType.LPARENTH) {
                String name2 = JavaNullMethodArgumentIndex.findMethodName(tokens, i);
                return name2 == null ? null : new MethodCallData(name2, commaCount);
            }
            i = tokens.backWithBraceMatching(i, JavaTokenType.LPARENTH, JavaTokenType.RPARENTH);
        }
        return null;
    }

    @Nullable
    private static String findMethodName(TokenList tokens, int lparenth) {
        int i = tokens.backWhile(lparenth - 1, JavaParserUtil.WS_COMMENTS);
        if (tokens.hasType(i, JavaTokenType.GT)) {
            i = tokens.backWhile(tokens.backWithBraceMatching(i, JavaTokenType.LT, JavaTokenType.GT), JavaParserUtil.WS_COMMENTS);
        }
        return tokens.getTokenType(i) == JavaTokenType.IDENTIFIER ? tokens.getTokenText(i).toString() : null;
    }

    @NotNull
    public KeyDescriptor<MethodCallData> getKeyDescriptor() {
        return new KeyDescriptor<MethodCallData>(){

            public int getHashCode(MethodCallData value2) {
                return value2.hashCode();
            }

            public boolean isEqual(MethodCallData val1, MethodCallData val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, MethodCallData value2) throws IOException {
                EnumeratorStringDescriptor.INSTANCE.save(out, value2.getMethodName());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.getNullParameterIndex());
            }

            public MethodCallData read(@NotNull DataInput in) throws IOException {
                return new MethodCallData(EnumeratorStringDescriptor.INSTANCE.read(in), DataInputOutputUtil.readINT((DataInput)in));
            }
        };
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return JavaParserDefinition.JAVA_FILE.shouldBuildStubFor(file);
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    public static final class MethodCallData {
        @NotNull
        private final String myMethodName;
        private final int myNullParameterIndex;

        public MethodCallData(@NotNull String name2, int index) {
            this.myMethodName = name2;
            this.myNullParameterIndex = index;
        }

        @NotNull
        public String getMethodName() {
            return this.myMethodName;
        }

        public int getNullParameterIndex() {
            return this.myNullParameterIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallData data = (MethodCallData)o;
            if (this.myNullParameterIndex != data.myNullParameterIndex) {
                return false;
            }
            return this.myMethodName.equals(data.myMethodName);
        }

        public int hashCode() {
            int result = this.myMethodName.hashCode();
            result = 31 * result + this.myNullParameterIndex;
            return result;
        }

        public String toString() {
            return "MethodCallData{myMethodName='" + this.myMethodName + '\'' + ", myNullParameterIndex=" + this.myNullParameterIndex + '}';
        }
    }
}

