/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class JavaFilesSearchScope
extends GlobalSearchScope {
    private final PsiManager myPsiManager;

    public JavaFilesSearchScope(@NotNull Project project) {
        super(project);
        this.myPsiManager = PsiManager.getInstance((Project)project);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return true;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file.isDirectory()) {
            return false;
        }
        FileViewProvider viewProvider = this.myPsiManager.findViewProvider(file);
        return viewProvider != null && viewProvider.hasLanguage((Language)JavaLanguage.INSTANCE);
    }
}

