/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.java.indexing.JavaIndexingBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.impl.search.LazyConcurrentCollection;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<? super PsiClass> consumer) {
        PsiClass baseClass = parameters2.getClassToProcess();
        assert (parameters2.isCheckDeep());
        assert (parameters2.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className2 = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
            progress.setText(className2 != null ? JavaIndexingBundle.message((String)"psi.search.inheritors.of.class.progress", (Object[])new Object[]{className2}) : JavaIndexingBundle.message((String)"psi.search.inheritors.progress", (Object[])new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters2, consumer);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static void processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<? super PsiClass> consumer) {
        @NotNull PsiClass baseClass = parameters2.getClassToProcess();
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return;
        }
        SearchScope searchScope = parameters2.getScope();
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            AllClassesSearch.search((SearchScope)searchScope, (Project)project, (Condition)parameters2.getNameCondition()).allowParallelProcessing().forEach(aClass -> {
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process(aClass);
            });
            return;
        }
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(((LocalSearchScope)searchScope).getVirtualFiles())) {
            JavaClassInheritorsSearcher.processLocalScope(project, parameters2, (LocalSearchScope)searchScope, baseClass, consumer);
            return;
        }
        if (!parameters2.isCheckDeep() && ApplicationManager.getApplication().isDispatchThread()) {
            DirectClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)searchScope).forEach(consumer);
            return;
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project, baseClass, searchScope, parameters2.isIncludeAnonymous());
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (!((Boolean)ReadAction.compute(() -> JavaClassInheritorsSearcher.checkCandidate(subClass, parameters2) && !consumer.process((Object)subClass))).booleanValue()) continue;
            return;
        }
    }

    @NotNull
    private static Iterable<PsiClass> getOrComputeSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull SearchScope searchScopeForNonPhysical, boolean includeAnonymous) {
        HighlightingCaches caches = HighlightingCaches.getInstance(project);
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map2 = includeAnonymous ? caches.ALL_SUB_CLASSES : caches.ALL_SUB_CLASSES_NO_ANONYMOUS;
        LazyConcurrentCollection<PsiAnchor, PsiClass> cached = (LazyConcurrentCollection<PsiAnchor, PsiClass>)map2.get(baseClass);
        if (cached == null) {
            Function converter = anchor -> (PsiClass)ReadAction.compute(() -> (PsiClass)anchor.retrieve());
            Predicate applicableFilter = candidate -> !(candidate instanceof PsiAnonymousClass) && candidate != null && !candidate.hasModifierProperty("final");
            boolean isPhysical = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical());
            SearchScope scopeToUse = isPhysical ? GlobalSearchScope.allScope((Project)project) : searchScopeForNonPhysical;
            LazyConcurrentCollection.MoreElementsGenerator generator = (candidate, processor2) -> DirectClassInheritorsSearch.search((PsiClass)candidate, (SearchScope)scopeToUse, (boolean)includeAnonymous).allowParallelProcessing().forEach(subClass -> {
                ProgressManager.checkCanceled();
                PsiAnchor pointer = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)subClass));
                processor2.consume((Object)pointer);
                return true;
            });
            PsiAnchor seed = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)baseClass));
            LazyConcurrentCollection<PsiAnchor, PsiClass> computed = new LazyConcurrentCollection<PsiAnchor, PsiClass>(seed, converter, applicableFilter, generator);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map2, (Object)baseClass, computed) : computed;
        }
        return cached;
    }

    private static void processLocalScope(final @NotNull Project project, final @NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull LocalSearchScope searchScope, final @NotNull PsiClass baseClass, final @NotNull Processor<? super PsiClass> consumer) {
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                            public void visitClass(PsiClass candidate) {
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters2) && !consumer.process((Object)candidate)) {
                                    success[0] = false;
                                    return;
                                }
                                super.visitClass(candidate);
                            }
                        });
                    }
                }
            });
        }
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters2) {
        SearchScope searchScope = parameters2.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name2 = candidate.getName();
        return name2 != null && parameters2.getNameCondition().value((Object)name2);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        return (Boolean)ReadAction.compute(() -> baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName()));
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        return (Boolean)ReadAction.compute(() -> baseClass.hasModifierProperty("final"));
    }
}

