/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightRecordMethod
extends LightMethod
implements LightRecordMember {
    @NotNull
    private final PsiRecordComponent myRecordComponent;

    public LightRecordMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull PsiRecordComponent component) {
        super(manager, method, containingClass);
        this.myRecordComponent = component;
    }

    @Override
    @NotNull
    public PsiRecordComponent getRecordComponent() {
        return this.myRecordComponent;
    }

    public int getTextOffset() {
        return this.myRecordComponent.getTextOffset();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myRecordComponent.getNavigationElement();
    }

    public boolean isWritable() {
        return true;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass.getContainingFile();
    }

    @Override
    public PsiType getReturnType() {
        if (DumbService.isDumb((Project)this.myRecordComponent.getProject())) {
            return this.myRecordComponent.getType();
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiType type2 = this.myRecordComponent.getType().annotate(() -> (PsiAnnotation[])Arrays.stream(this.myRecordComponent.getAnnotations()).filter(LightRecordMethod::hasTargetApplicableForMethod).toArray(PsiAnnotation[]::new));
            return CachedValueProvider.Result.create((Object)type2, (Object[])new Object[]{this});
        });
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiType returnType = this.getReturnType();
        if (returnType == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        return returnType.getAnnotations();
    }

    public boolean hasAnnotation(@NotNull String fqn) {
        PsiType returnType = this.getReturnType();
        return returnType != null && returnType.hasAnnotation(fqn);
    }

    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        PsiType returnType = this.getReturnType();
        if (returnType == null) {
            return null;
        }
        return returnType.findAnnotation(fqn);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.METHOD_ICON, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        if (BitUtil.isSet((int)flags, (int)1)) {
            VisibilityIcons.setVisibilityIcon((int)4, (RowIcon)baseIcon);
        }
        return baseIcon;
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }

    private static boolean hasTargetApplicableForMethod(PsiAnnotation annotation) {
        return AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE, PsiAnnotation.TargetType.METHOD}) != null;
    }
}

