/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

class JavaAutoModuleFilterScope
extends DelegatingGlobalSearchScope {
    JavaAutoModuleFilterScope(@NotNull GlobalSearchScope baseScope) {
        super(baseScope);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (!super.contains(file)) {
            return false;
        }
        VirtualFile root = file;
        if (!file.isDirectory()) {
            root = file.getParent().getParent();
            Project project = this.getProject();
            if (project == null || !root.equals(ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(file))) {
                return false;
            }
        }
        return JavaModuleNameIndex.descriptorFile(root) == null;
    }
}

