/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalExpressionKey {
    public static final int UNKNOWN_PARAM_COUNT = -1;
    private final int lambdaParameterCount;
    private final CoarseType lambdaReturnType;
    @NotNull
    private final String knownType;

    public FunctionalExpressionKey(int lambdaParameterCount, @NotNull CoarseType lambdaReturnType, @Nullable String knownFunExprType) {
        this.lambdaParameterCount = lambdaParameterCount;
        this.lambdaReturnType = lambdaReturnType;
        this.knownType = StringUtil.notNullize((String)knownFunExprType);
    }

    @NotNull
    public static FunctionalExpressionKey deserializeKey(@NotNull DataInput dataStream) throws IOException {
        byte parameterCount = dataStream.readByte();
        CoarseType type2 = CoarseType.values()[dataStream.readByte()];
        String knownType = IOUtil.readUTF((DataInput)dataStream);
        return new FunctionalExpressionKey(parameterCount, type2, knownType);
    }

    public void serializeKey(@NotNull DataOutput dataStream) throws IOException {
        dataStream.writeByte(this.lambdaParameterCount);
        dataStream.writeByte(this.lambdaReturnType.ordinal());
        IOUtil.writeUTF((DataOutput)dataStream, (String)this.knownType);
    }

    public boolean canRepresent(int samParamCount, boolean booleanCompatible, boolean isVoid) {
        if (this.lambdaParameterCount >= 0 && samParamCount != this.lambdaParameterCount) {
            return false;
        }
        switch (this.lambdaReturnType) {
            case VOID: {
                return isVoid;
            }
            case NON_VOID: {
                return !isVoid;
            }
            case BOOLEAN: {
                return booleanCompatible;
            }
        }
        return true;
    }

    public static boolean isBooleanCompatible(PsiType samType) {
        return PsiType.BOOLEAN.equals((Object)samType) || TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)TypeConversionUtil.erasure((PsiType)samType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionalExpressionKey)) {
            return false;
        }
        FunctionalExpressionKey key2 = (FunctionalExpressionKey)o;
        if (this.lambdaParameterCount != key2.lambdaParameterCount) {
            return false;
        }
        if (this.lambdaReturnType != key2.lambdaReturnType) {
            return false;
        }
        return this.knownType.equals(key2.knownType);
    }

    public int hashCode() {
        int result = this.lambdaParameterCount;
        result = 31 * result + this.lambdaReturnType.ordinal();
        result = 31 * result + this.knownType.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lambdaParameterCount", this.lambdaParameterCount).add("type", (Object)this.lambdaReturnType).add("knownType", (Object)this.knownType).toString();
    }

    public static enum CoarseType {
        VOID,
        UNKNOWN,
        BOOLEAN,
        NON_VOID;

    }
}

