/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiJavaDirectoryImpl
extends PsiDirectoryImpl {
    private static final Logger LOG = Logger.getInstance(PsiJavaDirectoryImpl.class);

    public PsiJavaDirectoryImpl(PsiManagerImpl manager, VirtualFile file) {
        super(manager, file);
    }

    public void checkCreateFile(@NotNull String name2) throws IncorrectOperationException {
        FileType type2 = FileTypeManager.getInstance().getFileTypeByFileName(name2);
        if (type2 == StdFileTypes.CLASS && ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInSource(this.getVirtualFile())) {
            throw new IncorrectOperationException("Cannot create class-file");
        }
        super.checkCreateFile(name2);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiClass) {
            String name2 = ((PsiClass)element).getName();
            if (name2 != null) {
                PsiClass newClass = JavaDirectoryService.getInstance().createClass((PsiDirectory)this, name2);
                return newClass.replace(element);
            }
            LOG.error("not implemented");
            return null;
        }
        return super.add(element);
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiClass) {
            if (((PsiClass)element).getContainingClass() == null) {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface((PsiDirectory)this, ((PsiClass)element).getName());
            } else {
                LOG.error("not implemented");
            }
        } else {
            super.checkAdd(element);
        }
    }

    public ItemPresentation getPresentation() {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this);
        return aPackage != null && !StringUtil.isEmpty((String)aPackage.getName()) ? aPackage.getPresentation() : super.getPresentation();
    }
}

