/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ClsRepositoryPsiElement<T extends StubElement>
extends ClsElementImpl
implements StubBasedPsiElement<T> {
    private final T myStub;

    protected ClsRepositoryPsiElement(T stub) {
        this.myStub = stub;
    }

    public IStubElementType getElementType() {
        return this.myStub.getStubType();
    }

    public PsiElement getParent() {
        return this.myStub.getParentStub().getPsi();
    }

    @Override
    public PsiManager getManager() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file.getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        Object p = this.myStub;
        while (!(p instanceof PsiFileStub)) {
            p = p.getParentStub();
        }
        return (PsiFile)p.getPsi();
    }

    public T getStub() {
        return this.myStub;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    public PsiElement @NotNull [] getChildren() {
        List stubs = this.getStub().getChildrenStubs();
        if (stubs.size() == 0) {
            return EMPTY_ARRAY;
        }
        PsiElement[] children = new PsiElement[stubs.size()];
        for (int i = 0; i < stubs.size(); ++i) {
            children[i] = ((StubElement)stubs.get(i)).getPsi();
        }
        return children;
    }

    public PsiElement getFirstChild() {
        List children = this.getStub().getChildrenStubs();
        return children.isEmpty() ? null : ((StubElement)children.get(0)).getPsi();
    }

    public PsiElement getLastChild() {
        List children = this.getStub().getChildrenStubs();
        return children.isEmpty() ? null : ((StubElement)children.get(children.size() - 1)).getPsi();
    }

    public PsiElement getNextSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i = ArrayUtil.indexOf((Object[])psiElements, (Object)((Object)this));
        if (i < 0 || i >= psiElements.length - 1) {
            return null;
        }
        return psiElements[i + 1];
    }

    public PsiElement getPrevSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i = ArrayUtil.indexOf((Object[])psiElements, (Object)((Object)this));
        if (i < 1) {
            return null;
        }
        return psiElements[i - 1];
    }
}

