/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceListImpl
extends ClsRepositoryPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final ClsJavaCodeReferenceElementImpl[] EMPTY_REFS_ARRAY = new ClsJavaCodeReferenceElementImpl[0];
    private final NotNullLazyValue<ClsJavaCodeReferenceElementImpl[]> myRefs = new AtomicNotNullLazyValue<ClsJavaCodeReferenceElementImpl[]>(){

        protected ClsJavaCodeReferenceElementImpl @NotNull [] compute() {
            String[] strings = ((PsiClassReferenceListStub)ClsReferenceListImpl.this.getStub()).getReferencedNames();
            if (strings.length > 0) {
                ClsJavaCodeReferenceElementImpl[] refs = new ClsJavaCodeReferenceElementImpl[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    refs[i] = new ClsJavaCodeReferenceElementImpl((PsiElement)ClsReferenceListImpl.this, strings[i]);
                }
                return refs;
            }
            return EMPTY_REFS_ARRAY;
        }
    };

    public ClsReferenceListImpl(@NotNull PsiClassReferenceListStub stub) {
        super(stub);
    }

    public PsiJavaCodeReferenceElement @NotNull [] getReferenceElements() {
        return (PsiJavaCodeReferenceElement[])this.myRefs.getValue();
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        return this.getReferenceElements();
    }

    public PsiClassType @NotNull [] getReferencedTypes() {
        return ((PsiClassReferenceListStub)this.getStub()).getReferencedTypes();
    }

    public PsiReferenceList.Role getRole() {
        return ((PsiClassReferenceListStub)this.getStub()).getRole();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        String[] names2 = ((PsiClassReferenceListStub)this.getStub()).getReferencedNames();
        if (names2.length != 0) {
            switch (this.getRole()) {
                case EXTENDS_BOUNDS_LIST: 
                case EXTENDS_LIST: {
                    buffer.append("extends").append(' ');
                    break;
                }
                case IMPLEMENTS_LIST: {
                    buffer.append("implements").append(' ');
                    break;
                }
                case THROWS_LIST: {
                    buffer.append("throws").append(' ');
                    break;
                }
                case PROVIDES_WITH_LIST: {
                    buffer.append("with").append(' ');
                }
            }
            for (int i = 0; i < names2.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(names2[i]);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        ClsReferenceListImpl.setMirrors((PsiElement[])this.getReferenceElements(), (PsiElement[])((PsiReferenceList)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element)).getReferenceElements());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceList((PsiReferenceList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiReferenceList";
    }
}

