/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsClassImpl
extends ClsMemberImpl<PsiClassStub<?>>
implements PsiExtensibleClass,
Queryable {
    public static final Key<PsiClass> DELEGATE_KEY = Key.create((String)"DELEGATE");
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    public ClsClassImpl(PsiClassStub stub) {
        super(stub);
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        ContainerUtil.addAll(children, (Object[])this.getChildren(new PsiElement[]{this.getDocComment(), this.getModifierListInternal(), this.getNameIdentifier(), this.getExtendsList(), this.getImplementsList()}));
        children.addAll(this.getOwnFields());
        children.addAll(this.getOwnMethods());
        children.addAll(this.getOwnInnerClasses());
        return PsiUtilCore.toPsiElementArray(children);
    }

    @NotNull
    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)((PsiTypeParameterListStub)Objects.requireNonNull(((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST))).getPsi();
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @Nullable
    public String getQualifiedName() {
        return ((PsiClassStub)this.getStub()).getQualifiedName();
    }

    private boolean isLocalClass() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        return stub instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub).isLocalClassInner();
    }

    private boolean isAnonymousOrLocalClass() {
        return this instanceof PsiAnonymousClass || this.isLocalClass();
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return this.getModifierListInternal();
    }

    private PsiModifierList getModifierListInternal() {
        return (PsiModifierList)((PsiModifierListStub)Objects.requireNonNull(((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST))).getPsi();
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return this.getModifierListInternal().hasModifierProperty(name2);
    }

    @NotNull
    public PsiReferenceList getExtendsList() {
        return (PsiReferenceList)((PsiClassReferenceListStub)Objects.requireNonNull(((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.EXTENDS_LIST))).getPsi();
    }

    @NotNull
    public PsiReferenceList getImplementsList() {
        return (PsiReferenceList)((PsiClassReferenceListStub)Objects.requireNonNull(((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.IMPLEMENTS_LIST))).getPsi();
    }

    public PsiClassType @NotNull [] getExtendsListTypes() {
        return PsiClassImplUtil.getExtendsListTypes(this);
    }

    public PsiClassType @NotNull [] getImplementsListTypes() {
        return PsiClassImplUtil.getImplementsListTypes(this);
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    public PsiClass @NotNull [] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    public PsiClass @NotNull [] getSupers() {
        if ("java.lang.Object".equals(this.getQualifiedName())) {
            return PsiClass.EMPTY_ARRAY;
        }
        return PsiClassImplUtil.getSupers(this);
    }

    public PsiClassType @NotNull [] getSuperTypes() {
        if ("java.lang.Object".equals(this.getQualifiedName())) {
            return PsiClassType.EMPTY_ARRAY;
        }
        return PsiClassImplUtil.getSuperTypes(this);
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return PsiSuperMethodImplUtil.getVisibleSignatures(this);
    }

    public PsiField @NotNull [] getFields() {
        return this.myInnersCache.getFields();
    }

    public PsiMethod @NotNull [] getMethods() {
        return this.myInnersCache.getMethods();
    }

    public PsiMethod @NotNull [] getConstructors() {
        return this.myInnersCache.getConstructors();
    }

    public PsiClass @NotNull [] getInnerClasses() {
        return this.myInnersCache.getInnerClasses();
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        return Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        return Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        PsiClass[] classes2 = (PsiClass[])((PsiClassStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        if (classes2.length == 0) {
            return Collections.emptyList();
        }
        int anonymousOrLocalClassesCount = 0;
        for (PsiClass aClass : classes2) {
            if (!(aClass instanceof ClsClassImpl) || !((ClsClassImpl)aClass).isAnonymousOrLocalClass()) continue;
            ++anonymousOrLocalClassesCount;
        }
        if (anonymousOrLocalClassesCount == 0) {
            return Arrays.asList(classes2);
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes2.length - anonymousOrLocalClassesCount);
        for (PsiClass aClass : classes2) {
            if (aClass instanceof ClsClassImpl && ((ClsClassImpl)aClass).isAnonymousOrLocalClass()) continue;
            result.add(aClass);
        }
        return result;
    }

    public PsiClassInitializer @NotNull [] getInitializers() {
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    public PsiTypeParameter @NotNull [] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiField @NotNull [] getAllFields() {
        return PsiClassImplUtil.getAllFields(this);
    }

    public PsiMethod @NotNull [] getAllMethods() {
        return PsiClassImplUtil.getAllMethods(this);
    }

    public PsiClass @NotNull [] getAllInnerClasses() {
        return PsiClassImplUtil.getAllInnerClasses(this);
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        return this.myInnersCache.findMethodsByName(name2, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name2, boolean checkBases) {
        return PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    public boolean isDeprecated() {
        return ((PsiClassStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public String getSourceFileName() {
        String sfn = ((PsiClassStub)this.getStub()).getSourceFileName();
        return sfn != null ? sfn : this.obtainSourceFileNameFromClassFileName();
    }

    @NonNls
    private String obtainSourceFileNameFromClassFileName() {
        String name2 = this.getContainingFile().getName();
        int i = name2.indexOf(36);
        if (i < 0 && (i = name2.indexOf(46)) < 0) {
            i = name2.length();
        }
        return name2.substring(0, i) + ".java";
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public boolean isInterface() {
        return ((PsiClassStub)this.getStub()).isInterface();
    }

    public boolean isAnnotationType() {
        return ((PsiClassStub)this.getStub()).isAnnotationType();
    }

    public boolean isEnum() {
        return ((PsiClassStub)this.getStub()).isEnum();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull @NonNls StringBuilder buffer) {
        int i;
        ClsClassImpl.appendText((PsiElement)this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsClassImpl.appendText((PsiElement)this.getModifierListInternal(), indentLevel, buffer);
        buffer.append(this.isEnum() ? "enum " : (this.isAnnotationType() ? "@interface " : (this.isInterface() ? "interface " : "class ")));
        ClsClassImpl.appendText((PsiElement)this.getNameIdentifier(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getTypeParameterList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getExtendsList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getImplementsList(), indentLevel, buffer, " ");
        buffer.append('{');
        int newIndentLevel = indentLevel + this.getIndentSize();
        List<PsiField> fields = this.getOwnFields();
        List<PsiMethod> methods = this.getOwnMethods();
        List<PsiClass> classes2 = this.getOwnInnerClasses();
        if (!fields.isEmpty()) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < fields.size(); ++i) {
                PsiField field = fields.get(i);
                ClsClassImpl.appendText((PsiElement)field, newIndentLevel, buffer);
                if (field instanceof ClsEnumConstantImpl) {
                    if (i < fields.size() - 1 && fields.get(i + 1) instanceof ClsEnumConstantImpl) {
                        buffer.append(", ");
                        continue;
                    }
                    buffer.append(';');
                    if (i >= fields.size() - 1) continue;
                    buffer.append('\n');
                    ClsClassImpl.goNextLine(newIndentLevel, buffer);
                    continue;
                }
                if (i >= fields.size() - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        } else if (this.isEnum() && methods.size() + classes2.size() > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            buffer.append(";");
        }
        if (!methods.isEmpty()) {
            if (this.isEnum() || !fields.isEmpty()) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < methods.size(); ++i) {
                ClsClassImpl.appendText((PsiElement)methods.get(i), newIndentLevel, buffer);
                if (i >= methods.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if (!classes2.isEmpty()) {
            if (fields.size() + methods.size() > 0) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < classes2.size(); ++i) {
                ClsClassImpl.appendText((PsiElement)classes2.get(i), newIndentLevel, buffer);
                if (i >= classes2.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        ClsClassImpl.goNextLine(indentLevel, buffer);
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        PsiClass mirror = (PsiClass)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsClassImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        PsiModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            ClsClassImpl.setMirror(modifierList, mirror.getModifierList());
        }
        ClsClassImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsClassImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        ClsClassImpl.setMirror(this.getExtendsList(), mirror.getExtendsList());
        ClsClassImpl.setMirror(this.getImplementsList(), mirror.getImplementsList());
        if (mirror instanceof PsiExtensibleClass) {
            PsiExtensibleClass extMirror = (PsiExtensibleClass)mirror;
            ClsClassImpl.setMirrors(this.getOwnFields(), extMirror.getOwnFields());
            ClsClassImpl.setMirrors(this.getOwnMethods(), extMirror.getOwnMethods());
            ClsClassImpl.setMirrors(this.getOwnInnerClasses(), extMirror.getOwnInnerClasses());
        } else {
            ClsClassImpl.setMirrors(this.getOwnFields(), Arrays.asList(mirror.getFields()));
            ClsClassImpl.setMirrors(this.getOwnMethods(), Arrays.asList(mirror.getMethods()));
            ClsClassImpl.setMirrors(this.getOwnInnerClasses(), Arrays.asList(mirror.getInnerClasses()));
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitClass((PsiClass)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        LanguageLevel level = processor2 instanceof MethodsProcessor ? ((MethodsProcessor)processor2).getLanguageLevel() : PsiUtil.getLanguageLevel((PsiElement)place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor2, state, null, lastParent, place, level, false);
    }

    public PsiElement getScope() {
        return this.getParent();
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Nullable
    public PsiClass getSourceMirrorClass() {
        PsiClass delegate = (PsiClass)this.getUserData(DELEGATE_KEY);
        if (delegate instanceof ClsClassImpl) {
            return ((ClsClassImpl)delegate).getSourceMirrorClass();
        }
        String name2 = this.getName();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            if (!(parent instanceof PsiClassOwner)) {
                return null;
            }
            PsiClassOwner fileNavigationElement = (PsiClassOwner)parent.getNavigationElement();
            if (fileNavigationElement == parent) {
                return null;
            }
            for (PsiClass aClass : fileNavigationElement.getClasses()) {
                if (!name2.equals(aClass.getName())) continue;
                return aClass;
            }
        } else if (parent != null) {
            PsiClass[] innerClasses;
            ClsClassImpl parentClass = (ClsClassImpl)parent;
            PsiClass parentSourceMirror = parentClass.getSourceMirrorClass();
            if (parentSourceMirror == null) {
                return null;
            }
            for (PsiClass innerClass : innerClasses = parentSourceMirror.getInnerClasses()) {
                if (!name2.equals(innerClass.getName())) continue;
                return innerClass;
            }
        } else {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return null;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
            try {
                PsiElement navigationElement = navigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                return navigationElement;
            }
            catch (IndexNotReadyException navigationElement) {
            }
        }
        try {
            PsiElement sourceFile;
            PsiElement parent;
            PsiClass aClass = this.getSourceMirrorClass();
            if (aClass != null) {
                return aClass.getNavigationElement();
            }
            if ("package-info".equals(this.getName()) && (parent = this.getParent()) instanceof ClsFileImpl && (sourceFile = parent.getNavigationElement()) instanceof PsiJavaFile) {
                return sourceFile;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return this;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        return PsiClassImplUtil.getClassUseScope(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiClassImpl.putInfo(this, info);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }
}

