/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScopedClassHierarchy {
    private static final TObjectHashingStrategy<PsiClass> CLASS_HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            return StringUtil.notNullize((String)object.getQualifiedName()).hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            String qname1 = o1.getQualifiedName();
            if (qname1 != null) {
                return qname1.equals(o2.getQualifiedName());
            }
            return o1.getManager().areElementsEquivalent((PsiElement)o1, (PsiElement)o2);
        }
    };
    private final PsiClass myPlaceClass;
    private final GlobalSearchScope myResolveScope;
    private volatile Map<PsiClass, PsiClassType.ClassResolveResult> mySupersWithSubstitutors;
    private volatile List<PsiClassType.ClassResolveResult> myImmediateSupersWithCapturing;
    private final Map<LanguageLevel, Map<PsiClass, PsiSubstitutor>> myAllSupersWithCapturing = ConcurrentFactoryMap.createMap(this::calcAllMemberSupers);

    ScopedClassHierarchy(PsiClass psiClass, GlobalSearchScope resolveScope) {
        this.myPlaceClass = psiClass;
        this.myResolveScope = resolveScope;
    }

    void visitType(@NotNull PsiClassType type2, Map<PsiClass, PsiClassType.ClassResolveResult> map2) {
        PsiClassType.ClassResolveResult resolveResult = type2.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null || InheritanceImplUtil.hasObjectQualifiedName(psiClass) || map2.containsKey(psiClass)) {
            return;
        }
        map2.put(psiClass, resolveResult);
        for (PsiType superType : ScopedClassHierarchy.getSuperTypes(psiClass)) {
            Object object = superType = type2.isRaw() && superType instanceof PsiClassType ? ((PsiClassType)superType).rawType() : resolveResult.getSubstitutor().substitute(superType);
            if (!((superType = PsiClassImplUtil.correctType(superType, this.myResolveScope)) instanceof PsiClassType)) continue;
            this.visitType((PsiClassType)superType, map2);
        }
    }

    @NotNull
    private static List<PsiType> getSuperTypes(PsiClass psiClass) {
        ArrayList<PsiType> superTypes = new ArrayList<PsiType>();
        if (psiClass instanceof PsiAnonymousClass) {
            ContainerUtil.addIfNotNull(superTypes, (Object)((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        Collections.addAll(superTypes, psiClass.getExtendsListTypes());
        Collections.addAll(superTypes, psiClass.getImplementsListTypes());
        return superTypes;
    }

    @NotNull
    static ScopedClassHierarchy getHierarchy(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        return (ScopedClassHierarchy)((Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(resolveScope1 -> new ScopedClassHierarchy(psiClass, (GlobalSearchScope)resolveScope1));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        })).get(resolveScope);
    }

    @Nullable
    static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiClass superClass) {
        PsiClassType.ClassResolveResult resolveResult;
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(derivedClass, scope);
        THashMap map2 = hierarchy.mySupersWithSubstitutors;
        if (map2 == null) {
            map2 = new THashMap(CLASS_HASHING_STRATEGY);
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            hierarchy.visitType(JavaPsiFacade.getElementFactory((Project)derivedClass.getProject()).createType(derivedClass, PsiSubstitutor.EMPTY), (Map<PsiClass, PsiClassType.ClassResolveResult>)map2);
            if (stamp.mayCacheNow()) {
                hierarchy.mySupersWithSubstitutors = map2;
            }
        }
        if ((resolveResult = map2.get(superClass)) == null) {
            return null;
        }
        PsiClass cachedClass = Objects.requireNonNull(resolveResult.getElement());
        PsiSubstitutor cachedSubstitutor = resolveResult.getSubstitutor();
        return cachedClass == superClass ? cachedSubstitutor : ScopedClassHierarchy.mirrorSubstitutor(superClass, cachedClass, cachedSubstitutor);
    }

    @NotNull
    private static PsiSubstitutor mirrorSubstitutor(@NotNull PsiClass from, @NotNull PsiClass to, @NotNull PsiSubstitutor substitutor) {
        Iterator baseParams = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)to);
        Iterator candidateParams = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)from);
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        while (baseParams.hasNext()) {
            if (!candidateParams.hasNext()) {
                return JavaClassSupersImpl.createRawSubstitutor(to);
            }
            answer = answer.put((PsiTypeParameter)baseParams.next(), substitutor.substitute((PsiTypeParameter)candidateParams.next()));
        }
        return answer;
    }

    @NotNull
    List<PsiClassType.ClassResolveResult> getImmediateSupersWithCapturing() {
        List list = this.myImmediateSupersWithCapturing;
        if (list == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            list = (List)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, () -> this.calcImmediateSupersWithCapturing());
            if (list == null) {
                return Collections.emptyList();
            }
            if (stamp.mayCacheNow()) {
                this.myImmediateSupersWithCapturing = list;
            }
        }
        return list;
    }

    @NotNull
    private List<PsiClassType.ClassResolveResult> calcImmediateSupersWithCapturing() {
        PsiClassType.ClassResolveResult objectResult;
        PsiUtilCore.ensureValid((PsiElement)this.myPlaceClass);
        ArrayList<PsiClassType.ClassResolveResult> list = new ArrayList<PsiClassType.ClassResolveResult>();
        for (PsiClassType type2 : this.myPlaceClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult result;
            PsiClass superClass;
            PsiUtil.ensureValidType((PsiType)type2, (PsiElement)this.myPlaceClass);
            PsiClassType corrected = PsiClassImplUtil.correctType(type2, this.myResolveScope);
            if (corrected == null || (superClass = (result = ((PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)corrected, (PsiElement)this.myPlaceClass)).resolveGenerics()).getElement()) == null || !PsiSearchScopeUtil.isInScope((GlobalSearchScope)this.myResolveScope, (PsiElement)superClass)) continue;
            list.add(result);
        }
        if (list.isEmpty() && this.myPlaceClass.getExtendsListTypes().length > 0 && (objectResult = PsiType.getJavaLangObject((PsiManager)this.myPlaceClass.getManager(), (GlobalSearchScope)this.myResolveScope).resolveGenerics()).getElement() != null) {
            list.add(objectResult);
        }
        return list;
    }

    @NotNull
    private Map<PsiClass, PsiSubstitutor> calcAllMemberSupers(LanguageLevel level) {
        THashMap map2 = new THashMap();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myPlaceClass.getProject());
        new PairProcessor<PsiClass, PsiSubstitutor>((Map)map2, factory, level){
            final /* synthetic */ Map val$map;
            final /* synthetic */ PsiElementFactory val$factory;
            final /* synthetic */ LanguageLevel val$level;
            {
                this.val$map = map2;
                this.val$factory = psiElementFactory;
                this.val$level = languageLevel;
            }

            public boolean process(PsiClass eachClass, PsiSubstitutor eachSubstitutor) {
                if (!this.val$map.containsKey(eachClass)) {
                    this.val$map.put(eachClass, eachSubstitutor);
                    PsiClassImplUtil.processSuperTypes(eachClass, eachSubstitutor, this.val$factory, this.val$level, ScopedClassHierarchy.this.myResolveScope, this);
                }
                return true;
            }
        }.process(this.myPlaceClass, PsiSubstitutor.EMPTY);
        return map2;
    }

    @Nullable
    PsiSubstitutor getSuperMembersSubstitutor(@NotNull PsiClass superClass, @NotNull LanguageLevel level) {
        return this.myAllSupersWithCapturing.get(level).get(superClass);
    }
}

