/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordAugmentProvider
extends PsiAugmentProvider
implements DumbAware {
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2, @Nullable String nameHint) {
        if (element instanceof PsiExtensibleClass) {
            PsiExtensibleClass aClass = (PsiExtensibleClass)element;
            if (!aClass.isRecord()) {
                return Collections.emptyList();
            }
            if (type2 == PsiMethod.class) {
                return RecordAugmentProvider.getAccessorsAugments(element, aClass);
            }
            if (type2 == PsiField.class) {
                return RecordAugmentProvider.getFieldAugments(element, aClass);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getAccessorsAugments(@NotNull PsiElement element, PsiExtensibleClass aClass) {
        PsiRecordHeader header = aClass.getRecordHeader();
        if (header == null) {
            return Collections.emptyList();
        }
        PsiRecordComponent[] components = aClass.getRecordComponents();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(components.length);
        List<PsiMethod> ownMethods = aClass.getOwnMethods();
        for (PsiRecordComponent component : components) {
            PsiMethod recordMethod;
            if (!RecordAugmentProvider.shouldGenerateMethod(component, ownMethods) || (recordMethod = RecordAugmentProvider.createRecordMethod(component, factory)) == null) continue;
            LightRecordMethod method = new LightRecordMethod(element.getManager(), recordMethod, (PsiClass)aClass, component);
            methods.add(method);
        }
        PsiMethod constructor = RecordAugmentProvider.getCanonicalConstructor(aClass, ownMethods, header);
        if (constructor != null) {
            methods.add(constructor);
        }
        return methods;
    }

    @Nullable
    private static PsiMethod getCanonicalConstructor(PsiExtensibleClass aClass, List<PsiMethod> ownMethods, @NotNull PsiRecordHeader recordHeader) {
        String className2 = aClass.getName();
        if (className2 == null) {
            return null;
        }
        for (PsiMethod method : ownMethods) {
            if (!JavaPsiRecordUtil.isCompactConstructor(method) && !JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) continue;
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)recordHeader.getProject());
        String sb = className2 + recordHeader.getText() + "{" + StringUtil.join((Object[])recordHeader.getRecordComponents(), c -> "this." + c.getName() + "=" + c.getName() + ";", (String)"\n") + "}";
        PsiMethod nonPhysical = factory.createMethodFromText(sb, (PsiElement)recordHeader.getContainingClass());
        PsiModifierList classModifierList = aClass.getModifierList();
        AccessModifier modifier = classModifierList == null ? AccessModifier.PUBLIC : AccessModifier.fromModifierList(classModifierList);
        nonPhysical.getModifierList().setModifierProperty(modifier.toPsiModifier(), true);
        return new LightRecordCanonicalConstructor(nonPhysical, aClass);
    }

    private static boolean shouldGenerateMethod(PsiRecordComponent component, List<PsiMethod> ownMethods) {
        String componentName = component.getName();
        if (componentName == null) {
            return false;
        }
        for (PsiMethod method : ownMethods) {
            if (!componentName.equals(method.getName()) || !method.getParameterList().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getFieldAugments(@NotNull PsiElement element, PsiClass aClass) {
        PsiRecordComponent[] components = aClass.getRecordComponents();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
        ArrayList<LightRecordField> fields = new ArrayList<LightRecordField>(components.length);
        for (PsiRecordComponent component : components) {
            PsiField recordField = RecordAugmentProvider.createRecordField(component, factory);
            if (recordField == null) continue;
            LightRecordField field = new LightRecordField(element.getManager(), recordField, aClass, component);
            fields.add(field);
        }
        return fields;
    }

    @Nullable
    private static PsiField createRecordField(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory) {
        String name2 = component.getName();
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        try {
            return factory.createFieldFromText("private final " + typeText + " " + name2 + ";", (PsiElement)component.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static PsiMethod createRecordMethod(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory) {
        String name2 = component.getName();
        if (name2 == null) {
            return null;
        }
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        try {
            return factory.createMethodFromText("public " + typeText + " " + name2 + "(){ return " + name2 + "; }", (PsiElement)component.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static boolean hasForbiddenType(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement = component.getTypeElement();
        return typeElement == null || typeElement.getText().equals("record");
    }

    @Nullable
    private static String getTypeText(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement = component.getTypeElement();
        if (typeElement == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (PsiElement child : typeElement.getChildren()) {
            if (child.getNode().getElementType() != JavaTokenType.ELLIPSIS) {
                sb.append(child.getText());
                continue;
            }
            sb.append("[]");
        }
        return sb.toString();
    }
}

