/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicCompletionContributor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.getters.BuilderCompletion;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMembersGetter
extends MembersGetter {
    private final PsiType myExpectedType;
    private final CompletionParameters myParameters;

    public JavaMembersGetter(@NotNull PsiType expectedType, CompletionParameters parameters2) {
        super(new JavaStaticMemberProcessor(parameters2), parameters2.getPosition());
        this.myExpectedType = JavaCompletionUtil.originalize(expectedType);
        this.myParameters = parameters2;
    }

    public void addMembers(boolean searchInheritors, Consumer<? super LookupElement> results) {
        if (MagicCompletionContributor.getAllowedValues(this.myParameters.getPosition()) != null) {
            return;
        }
        this.addConstantsFromTargetClass(results, searchInheritors);
        if (this.myExpectedType instanceof PsiPrimitiveType && PsiType.DOUBLE.isAssignableFrom(this.myExpectedType)) {
            this.addConstantsFromReferencedClassesInSwitch(results);
        }
        if (JavaCompletionContributor.IN_SWITCH_LABEL.accepts((Object)this.myPlace)) {
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)this.myExpectedType);
        this.processMembers(results, psiClass, PsiTreeUtil.getParentOfType((PsiElement)this.myPlace, PsiAnnotation.class) == null, searchInheritors);
        if (psiClass != null && this.myExpectedType instanceof PsiClassType) {
            new BuilderCompletion((PsiClassType)this.myExpectedType, psiClass, this.myPlace).suggestBuilderVariants().forEach(arg_0 -> results.consume(arg_0));
        }
    }

    private void addConstantsFromReferencedClassesInSwitch(Consumer<? super LookupElement> results) {
        if (!JavaCompletionContributor.IN_SWITCH_LABEL.accepts((Object)this.myPlace)) {
            return;
        }
        PsiSwitchBlock block = (PsiSwitchBlock)Objects.requireNonNull(PsiTreeUtil.getParentOfType((PsiElement)this.myPlace, PsiSwitchBlock.class));
        Set<PsiField> fields = ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(block);
        HashSet classes2 = new HashSet();
        for (PsiField field : fields) {
            ContainerUtil.addIfNotNull(classes2, (Object)field.getContainingClass());
        }
        for (PsiClass aClass : classes2) {
            this.processMembers((Consumer<? super LookupElement>)((Consumer)element -> {
                if (!fields.contains(element.getObject())) {
                    results.consume((Object)TailTypeDecorator.withTail((LookupElement)element, (TailType)TailTypes.forSwitchLabel(block)));
                }
            }), aClass, true, false);
        }
    }

    private void addConstantsFromTargetClass(Consumer<? super LookupElement> results, boolean searchInheritors) {
        PsiElement parent = this.myPlace.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement prev = parent;
        parent = parent.getParent();
        while (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            IElementType op = binaryExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ == op || JavaTokenType.NE == op) {
                if (prev == binaryExpression.getROperand()) {
                    this.processMembers(results, JavaMembersGetter.getCalledClass((PsiElement)binaryExpression.getLOperand()), true, searchInheritors);
                }
                return;
            }
            prev = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            this.processMembers(results, JavaMembersGetter.getCalledClass(parent.getParent()), true, searchInheritors);
        }
    }

    @Nullable
    private static PsiClass getCalledClass(@Nullable PsiElement call) {
        PsiJavaCodeReferenceElement reference;
        if (call instanceof PsiMethodCallExpression) {
            for (JavaResolveResult result : ((PsiMethodCallExpression)call).getMethodExpression().multiResolve(true)) {
                PsiClass aClass;
                PsiElement element = result.getElement();
                if (!(element instanceof PsiMethod) || (aClass = ((PsiMethod)element).getContainingClass()) == null || "java.lang.Math".equals(aClass.getQualifiedName())) continue;
                return aClass;
            }
        }
        if (call instanceof PsiNewExpression && (reference = ((PsiNewExpression)call).getClassReference()) != null) {
            for (JavaResolveResult result : reference.multiResolve(true)) {
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                return (PsiClass)element;
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected LookupElement createFieldElement(PsiField field) {
        if (!this.myExpectedType.isAssignableFrom(field.getType())) {
            return null;
        }
        return new VariableLookupItem(field, false).qualifyIfNeeded((PsiReference)ObjectUtils.tryCast((Object)this.myParameters.getPosition().getParent(), PsiJavaCodeReferenceElement.class));
    }

    @Override
    @Nullable
    protected LookupElement createMethodElement(PsiMethod method) {
        JavaMethodCallElement item = new JavaMethodCallElement(method, false, false);
        item.setInferenceSubstitutorFromExpectedType(this.myPlace, this.myExpectedType);
        PsiType type2 = item.getType();
        if (type2 == null || !this.myExpectedType.isAssignableFrom(type2)) {
            return null;
        }
        return item;
    }
}

