/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.ValueListPropertyAccessor;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPackageEntryTableAccessor
extends ValueListPropertyAccessor<PackageEntryTable> {
    public static final char BLANK_LINE_CHAR = '|';
    public static final String STATIC_PREFIX = "$";

    public JavaPackageEntryTableAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
    }

    @Nullable
    protected PackageEntryTable fromExternal(@NotNull List<String> strList) {
        PackageEntryTable entryTable = new PackageEntryTable();
        for (String strValue : strList) {
            String parseStr = strValue.trim();
            if (parseStr.length() > 0 && parseStr.charAt(0) == '|') {
                for (int i = 0; i < parseStr.length(); ++i) {
                    if (parseStr.charAt(i) != '|') continue;
                    entryTable.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                continue;
            }
            boolean isStatic = false;
            boolean isWithSubpackages = false;
            if (parseStr.startsWith(STATIC_PREFIX)) {
                parseStr = parseStr.substring(STATIC_PREFIX.length()).trim();
                isStatic = true;
            }
            if ((parseStr = parseStr.trim()).endsWith("**")) {
                isWithSubpackages = true;
                parseStr = parseStr.substring(0, parseStr.length() - 1);
            }
            if ("*".equals(parseStr)) {
                entryTable.addEntry(isStatic ? PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY : PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
                continue;
            }
            entryTable.addEntry(new PackageEntry(isStatic, parseStr, isWithSubpackages));
        }
        return entryTable;
    }

    @NotNull
    protected List<String> toExternal(@NotNull PackageEntryTable value2) {
        ArrayList<String> externalList = new ArrayList<String>();
        for (PackageEntry entry : value2.getEntries()) {
            if (entry == PackageEntry.BLANK_LINE_ENTRY) {
                externalList.add(String.valueOf('|'));
                continue;
            }
            StringBuilder entryBuilder = new StringBuilder();
            if (entry.isStatic()) {
                entryBuilder.append(STATIC_PREFIX);
            }
            if (entry.isSpecial()) {
                entryBuilder.append("*");
            } else {
                entryBuilder.append(entry.getPackageName()).append(".*");
                if (entry.isWithSubpackages()) {
                    entryBuilder.append("*");
                }
            }
            externalList.add(entryBuilder.toString());
        }
        return externalList;
    }

    @Nullable
    protected String valueToString(@NotNull List<String> value2) {
        return CodeStylePropertiesUtil.toCommaSeparatedString(value2);
    }
}

