/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final Logger LOG = Logger.getInstance(NonClasspathClassFinder.class);
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(@NotNull Project project, String ... fileExtensions) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myFileExtensions = (String[])ArrayUtil.append((Object[])fileExtensions, (Object)"class");
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                NonClasspathClassFinder.this.clearCache();
            }
        });
        LowMemoryWatcher.register(() -> {
            this.myCache = null;
        }, (Disposable)ExtensionPointUtil.createExtensionDisposable((Object)((Object)this), (ExtensionPoint)EP.getPoint((AreaInstance)project)));
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        PackageDirectoryCache cache = this.myCache;
        if (cache == null) {
            List roots = this.calcClassRoots();
            List invalidRoots = ContainerUtil.filter(roots, f -> !f.isValid());
            if (!invalidRoots.isEmpty()) {
                roots = ContainerUtil.filter(roots, VirtualFile::isValid);
                PluginException.logPluginError((Logger)LOG, (String)("Invalid roots returned by " + ((Object)((Object)this)).getClass().getName() + ": " + invalidRoots), null, ((Object)((Object)this)).getClass());
            }
            this.myCache = cache = PackageDirectoryCache.createCache(roots);
        }
        return cache;
    }

    @Deprecated
    @NotNull
    protected static PackageDirectoryCache createCache(@NotNull List<? extends VirtualFile> roots) {
        return PackageDirectoryCache.createCache(roots);
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getCache(scope).getDirectoriesByPackageName("");
    }

    @Contract(pure=true)
    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots((GlobalSearchScope)ALL_SCOPE);
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Ref result = Ref.create();
        this.processDirectories(StringUtil.getPackageName((String)qualifiedName), scope, (Processor<? super VirtualFile>)((Processor)dir -> {
            PsiClass[] classes2;
            PsiFile file;
            VirtualFile virtualFile = NonClasspathClassFinder.findChild(dir, StringUtil.getShortName((String)qualifiedName), this.myFileExtensions);
            PsiFile psiFile = file = virtualFile == null ? null : this.myManager.findFile(virtualFile);
            if (file instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)file).getClasses()).length == 1) {
                result.set((Object)classes2[0]);
                return false;
            }
            return true;
        }));
        return (PsiClass)result.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        ArrayList result = new ArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope, (Processor<? super VirtualFile>)((Processor)dir -> {
            for (VirtualFile file : dir.getChildren()) {
                PsiFile psi;
                if (file.isDirectory() || !ArrayUtil.contains((String)file.getExtension(), (String[])this.myFileExtensions) || !((psi = this.myManager.findFile(file)) instanceof PsiClassOwner)) continue;
                ContainerUtil.addAll((Collection)result, (Object[])((PsiClassOwner)psi).getClasses());
            }
            return true;
        }));
        return result.toArray(PsiClass.EMPTY_ARRAY);
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        HashSet<String> result = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope, (Processor<? super VirtualFile>)((Processor)dir -> {
            for (VirtualFile file : dir.getChildren()) {
                if (file.isDirectory() || !ArrayUtil.contains((String)file.getExtension(), (String[])this.myFileExtensions)) continue;
                result.add(file.getNameWithoutExtension());
            }
            return true;
        }));
        return result;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.processDirectories(qualifiedName, (GlobalSearchScope)ALL_SCOPE, (Processor<? super VirtualFile>)processor2);
        return processor2.getFoundValue() != null ? this.createPackage(qualifiedName) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        return this.processDirectories(psiPackage.getQualifiedName(), scope, (Processor<? super VirtualFile>)((Processor)dir -> {
            PsiDirectory psiDirectory = psiPackage.getManager().findDirectory(dir);
            return psiDirectory == null || consumer.process((Object)psiDirectory);
        }));
    }

    private boolean processDirectories(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor2) {
        return ContainerUtil.process((List)this.getCache(scope).getDirectoriesByPackageName(qualifiedName), file -> !scope.contains(file) || processor2.process(file));
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        String pkgName = psiPackage.getQualifiedName();
        Set names2 = this.getCache(scope).getSubpackageNames(pkgName);
        if (names2.isEmpty()) {
            return super.getSubPackages(psiPackage, scope);
        }
        ArrayList<PsiPackageImpl> result = new ArrayList<PsiPackageImpl>();
        for (String name2 : names2) {
            result.add(this.createPackage(pkgName.isEmpty() ? name2 : pkgName + "." + name2));
        }
        return result.toArray(PsiPackage.EMPTY_ARRAY);
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        PsiClass psiClass = this.findClass(qualifiedName, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project, @NotNull GlobalSearchScope base) {
        SmartList nonClasspathScopes = new SmartList();
        for (PsiElementFinder finder : EP.getExtensions((AreaInstance)project)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            nonClasspathScopes.add(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        if (nonClasspathScopes.isEmpty()) {
            return base;
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])ArrayUtil.prepend((Object)base, (Object[])nonClasspathScopes.toArray(GlobalSearchScope.EMPTY_ARRAY))));
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root, @NotNull String relPath, String @NotNull [] extensions) {
        VirtualFile file = null;
        for (String extension : extensions) {
            file = root.findChild(relPath + '.' + extension);
            if (file != null) break;
        }
        return file;
    }
}

