/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ExtractedDirectoryPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryPackagingElement
extends FileOrDirectoryCopyPackagingElement<ExtractedDirectoryPackagingElement> {
    private String myPathInJar;

    public ExtractedDirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE);
    }

    public ExtractedDirectoryPackagingElement(String jarPath, String pathInJar) {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, jarPath);
        this.myPathInJar = pathInJar;
        if (!StringUtil.startsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = "/" + this.myPathInJar;
        }
        if (!StringUtil.endsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = this.myPathInJar + "/";
        }
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new ExtractedDirectoryPresentation(this);
    }

    public String toString() {
        return "extracted:" + this.myFilePath + "!" + this.myPathInJar;
    }

    @Override
    public VirtualFile findFile() {
        VirtualFile jarFile = super.findFile();
        if (jarFile == null) {
            return null;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
        if ("/".equals(this.myPathInJar)) {
            return jarRoot;
        }
        return jarRoot != null ? jarRoot.findFileByRelativePath(this.myPathInJar) : null;
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        return element instanceof ExtractedDirectoryPackagingElement && super.isEqualTo(element) && Objects.equals(this.myPathInJar, ((ExtractedDirectoryPackagingElement)element).getPathInJar());
    }

    public ExtractedDirectoryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull ExtractedDirectoryPackagingElement state) {
        this.myFilePath = state.getFilePath();
        this.myPathInJar = state.getPathInJar();
    }

    @Attribute(value="path-in-jar")
    public String getPathInJar() {
        return this.myPathInJar;
    }

    public void setPathInJar(String pathInJar) {
        this.myPathInJar = pathInJar;
    }
}

