/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public final class ArtifactCompilerUtil {
    private ArtifactCompilerUtil() {
    }

    public static boolean containsArtifacts(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            if (!ArtifactBuildTargetType.INSTANCE.getTypeId().equals(scope.getTypeId())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Map<String, List<Artifact>> createOutputToArtifactMap(@NotNull Project project) {
        Map result = CollectionFactory.createFilePathMap();
        ReadAction.run(() -> {
            for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
                String outputPath = artifact.getOutputFilePath();
                if (StringUtil.isEmpty((String)outputPath)) continue;
                result.computeIfAbsent(outputPath, __ -> new SmartList()).add(artifact);
            }
        });
        return result;
    }
}

