/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashMap;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureConfigurableContext
implements Disposable,
LibraryEditorListener {
    private final ProjectStructureDaemonAnalyzer myDaemonAnalyzer;
    public final ModulesConfigurator myModulesConfigurator;
    public final Map<String, LibrariesModifiableModel> myLevel2Providers = new THashMap();
    private final EventDispatcher<LibraryEditorListener> myLibraryEditorListeners = EventDispatcher.create(LibraryEditorListener.class);
    private final Project myProject;

    public StructureConfigurableContext(Project project, ModulesConfigurator modulesConfigurator) {
        this.myProject = project;
        this.myModulesConfigurator = modulesConfigurator;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDaemonAnalyzer = new ProjectStructureDaemonAnalyzer(this);
    }

    public VirtualFile[] getLibraryFiles(Library library, OrderRootType type2) {
        LibrariesModifiableModel librariesModel;
        LibraryTable.ModifiableModel modifiableModel;
        LibraryTable table = library.getTable();
        if (table != null && (modifiableModel = this.getModifiableLibraryTable(table)) instanceof LibrariesModifiableModel && (librariesModel = (LibrariesModifiableModel)modifiableModel).hasLibraryEditor(library)) {
            return librariesModel.getLibraryEditor(library).getFiles(type2);
        }
        return library.getFiles(type2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ProjectStructureDaemonAnalyzer getDaemonAnalyzer() {
        return this.myDaemonAnalyzer;
    }

    public void dispose() {
    }

    public ModulesConfigurator getModulesConfigurator() {
        return this.myModulesConfigurator;
    }

    public Module[] getModules() {
        return this.myModulesConfigurator.getModules();
    }

    public String getRealName(Module module) {
        return this.myModulesConfigurator.getModuleModel().getActualName(module);
    }

    public void resetLibraries() {
        LibraryTablesRegistrar tablesRegistrar = LibraryTablesRegistrar.getInstance();
        this.myLevel2Providers.clear();
        this.myLevel2Providers.put("application", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(), this.myProject, this));
        this.myLevel2Providers.put("project", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(this.myProject), this.myProject, this));
        for (LibraryTable table : tablesRegistrar.getCustomLibraryTables()) {
            this.myLevel2Providers.put(table.getTableLevel(), new LibrariesModifiableModel(table, this.myProject, this));
        }
    }

    public void addLibraryEditorListener(LibraryEditorListener listener) {
        this.myLibraryEditorListeners.addListener((EventListener)listener);
    }

    public void addLibraryEditorListener(@NotNull LibraryEditorListener listener, @NotNull Disposable parentDisposable) {
        this.myLibraryEditorListeners.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
        ((LibraryEditorListener)this.myLibraryEditorListeners.getMulticaster()).libraryRenamed(library, oldName, newName);
    }

    @NotNull
    public StructureLibraryTableModifiableModelProvider getGlobalLibrariesProvider() {
        return this.createModifiableModelProvider("application");
    }

    @NotNull
    public StructureLibraryTableModifiableModelProvider createModifiableModelProvider(@NotNull String level) {
        return new StructureLibraryTableModifiableModelProvider(level, this);
    }

    @NotNull
    public StructureLibraryTableModifiableModelProvider getProjectLibrariesProvider() {
        return this.createModifiableModelProvider("project");
    }

    public LibraryTable.ModifiableModel getModifiableLibraryTable(@NotNull LibraryTable table) {
        String tableLevel = table.getTableLevel();
        if (tableLevel.equals("module")) {
            return table.getModifiableModel();
        }
        return this.myLevel2Providers.get(tableLevel);
    }

    @Nullable
    public Library getLibrary(String libraryName, @NotNull String libraryLevel) {
        LibrariesModifiableModel model = this.myLevel2Providers.get(libraryLevel);
        return model == null ? null : StructureConfigurableContext.findLibraryModel(libraryName, model);
    }

    @Nullable
    private static Library findLibraryModel(@NotNull String libraryName, @NotNull LibrariesModifiableModel model) {
        for (Library library : model.getLibraries()) {
            Library libraryModel = StructureConfigurableContext.findLibraryModel(library, model);
            if (libraryModel == null || !libraryName.equals(libraryModel.getName())) continue;
            return libraryModel;
        }
        return null;
    }

    @Nullable
    public Library getLibraryModel(@NotNull Library library) {
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            return StructureConfigurableContext.findLibraryModel(library, this.myLevel2Providers.get(libraryTable.getTableLevel()));
        }
        return library;
    }

    @Nullable
    private static Library findLibraryModel(Library library, LibrariesModifiableModel tableModel) {
        if (tableModel == null) {
            return library;
        }
        if (tableModel.wasLibraryRemoved(library)) {
            return null;
        }
        return tableModel.hasLibraryEditor(library) ? (Library)tableModel.getLibraryEditor(library).getModel() : library;
    }

    public void reset() {
        this.resetLibraries();
        this.myModulesConfigurator.resetModuleEditors();
        this.myDaemonAnalyzer.reset();
    }

    public void clear() {
        this.myLevel2Providers.clear();
    }
}

