/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLibraryAction
extends DumbAwareAction {
    @Nullable
    private final LibraryType myType;
    private final BaseLibrariesConfigurable myLibrariesConfigurable;
    private final Project myProject;

    private CreateNewLibraryAction(@NotNull String text2, @Nullable Icon icon, @Nullable LibraryType type2, @NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull Project project) {
        super(text2, null, icon);
        this.myType = type2;
        this.myLibrariesConfigurable = librariesConfigurable;
        this.myProject = project;
    }

    @Nullable
    public static Library createLibrary(@Nullable LibraryType type2, @NotNull JComponent parentComponent, @NotNull Project project, @NotNull LibrariesModifiableModel modifiableModel) {
        NewLibraryConfiguration configuration = CreateNewLibraryAction.createNewLibraryConfiguration(type2, parentComponent, project);
        if (configuration == null) {
            return null;
        }
        LibraryType libraryType = configuration.getLibraryType();
        Library library = modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName(modifiableModel, configuration.getDefaultLibraryName()), libraryType != null ? libraryType.getKind() : null);
        NewLibraryEditor editor = new NewLibraryEditor(libraryType, configuration.getProperties());
        configuration.addRoots((LibraryEditor)editor);
        Library.ModifiableModel model = library.getModifiableModel();
        editor.applyTo((LibraryEx.ModifiableModelEx)model);
        WriteAction.run(() -> model.commit());
        return library;
    }

    @Nullable
    public static NewLibraryConfiguration createNewLibraryConfiguration(@Nullable LibraryType type2, @NotNull JComponent parentComponent, @NotNull Project project) {
        VirtualFile baseDir = project.getBaseDir();
        NewLibraryConfiguration configuration = type2 != null ? type2.createNewLibrary(parentComponent, baseDir, project) : LibraryTypeService.getInstance().createLibraryFromFiles((LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor(), parentComponent, baseDir, null, project);
        if (configuration == null) {
            return null;
        }
        return configuration;
    }

    public static AnAction[] createActionOrGroup(@NotNull String text2, @NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull Project project) {
        LibraryType[] extensions = (LibraryType[])LibraryType.EP_NAME.getExtensions();
        ArrayList<LibraryType> suitableTypes = new ArrayList<LibraryType>();
        if (librariesConfigurable instanceof ProjectLibrariesConfigurable || !project.isDefault()) {
            ModuleStructureConfigurable configurable = ModuleStructureConfigurable.getInstance(project);
            for (LibraryType extension : extensions) {
                if (LibraryEditingUtil.getSuitableModules(configurable, (LibraryKind)extension.getKind(), null).isEmpty()) continue;
                suitableTypes.add(extension);
            }
        } else {
            Collections.addAll(suitableTypes, extensions);
        }
        if (suitableTypes.isEmpty()) {
            return new AnAction[]{new CreateNewLibraryAction(text2, PlatformIcons.LIBRARY_ICON, null, librariesConfigurable, project)};
        }
        ArrayList<CreateNewLibraryAction> actions = new ArrayList<CreateNewLibraryAction>();
        actions.add(new CreateNewLibraryAction(JavaUiBundle.message("create.default.library.type.action.name", new Object[0]), PlatformIcons.LIBRARY_ICON, null, librariesConfigurable, project));
        for (LibraryType type2 : suitableTypes) {
            String actionName = type2.getCreateActionName();
            if (actionName == null) continue;
            actions.add(new CreateNewLibraryAction(actionName, type2.getIcon(null), type2, librariesConfigurable, project));
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Library library = CreateNewLibraryAction.createLibrary(this.myType, (JComponent)this.myLibrariesConfigurable.getTree(), this.myProject, this.myLibrariesConfigurable.getModelProvider().getModifiableModel());
        if (library == null) {
            return;
        }
        BaseLibrariesConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        MasterDetailsComponent.MyNode libraryNode = MasterDetailsComponent.findNodeByObject((TreeNode)((TreeNode)rootConfigurable.getTree().getModel().getRoot()), (Object)library);
        rootConfigurable.selectNodeInTree((DefaultMutableTreeNode)libraryNode);
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.myProject, true);
    }
}

