/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PutSourceItemIntoParentAndLinkViaManifestAction
extends PutIntoDefaultLocationActionBase {
    public PutSourceItemIntoParentAndLinkViaManifestAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Artifact artifact = this.myArtifactEditor.getArtifact();
        ParentElementsInfo parentInfo = this.findParentAndGrandParent(artifact);
        if (parentInfo != null) {
            presentation.setText(JavaUiBundle.message("action.text.put.into.0.and.link.via.manifest", parentInfo.getGrandparentArtifact().getName()));
        }
        boolean enable = parentInfo != null;
        boolean isProvideElements = false;
        for (PackagingSourceItem item : this.mySourceItemsTree.getSelectedItems()) {
            isProvideElements |= item.isProvideElements();
            if (item.getKindOfProducedElements().containsJarFiles()) continue;
            enable = false;
            break;
        }
        presentation.setEnabledAndVisible(enable &= isProvideElements);
    }

    @Nullable
    private ParentElementsInfo findParentAndGrandParent(Artifact artifact) {
        final Ref result = Ref.create(null);
        ArtifactUtil.processParents(artifact, (PackagingElementResolvingContext)this.myArtifactEditor.getContext(), new ParentElementProcessor(){

            @Override
            public boolean process(@NotNull CompositePackagingElement<?> element, @NotNull List<? extends Pair<Artifact, CompositePackagingElement<?>>> parents, @NotNull Artifact artifact) {
                if (parents.size() == 1) {
                    Pair<Artifact, CompositePackagingElement<?>> parent = parents.get(0);
                    result.set((Object)new ParentElementsInfo((Artifact)parent.getFirst(), (CompositePackagingElement)parent.getSecond(), artifact, element));
                    return false;
                }
                return true;
            }
        }, 1);
        return (ParentElementsInfo)result.get();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<PackagingSourceItem> items = this.mySourceItemsTree.getSelectedItems();
        ParentElementsInfo parentsInfo = this.findParentAndGrandParent(this.myArtifactEditor.getArtifact());
        if (parentsInfo == null) {
            return;
        }
        Artifact artifact = parentsInfo.getGrandparentArtifact();
        ArtifactEditorContext context = this.myArtifactEditor.getContext();
        Runnable emptyRunnable = EmptyRunnable.getInstance();
        context.editLayout(artifact, emptyRunnable);
        context.editLayout(parentsInfo.getParentArtifact(), emptyRunnable);
        parentsInfo = this.findParentAndGrandParent(this.myArtifactEditor.getArtifact());
        if (parentsInfo == null) {
            return;
        }
        CompositePackagingElement<?> grandParent = parentsInfo.getGrandparentElement();
        ArrayList classpath = new ArrayList();
        context.editLayout(artifact, () -> {
            for (PackagingSourceItem item : items) {
                List elements = item.createElements(context);
                grandParent.addOrFindChildren((Collection)elements);
                classpath.addAll(ManifestFileUtil.getClasspathForElements(elements, (PackagingElementResolvingContext)context, artifact.getArtifactType()));
            }
        });
        ArtifactEditor parentArtifactEditor = context.getOrCreateEditor(parentsInfo.getParentArtifact());
        parentArtifactEditor.addToClasspath(parentsInfo.getParentElement(), classpath);
        ((ArtifactEditorImpl)context.getOrCreateEditor(parentsInfo.getGrandparentArtifact())).rebuildTries();
    }

    private static class ParentElementsInfo {
        private final Artifact myParentArtifact;
        private final CompositePackagingElement<?> myParentElement;
        private final Artifact myGrandparentArtifact;
        private final CompositePackagingElement<?> myGrandparentElement;

        private ParentElementsInfo(Artifact parentArtifact, CompositePackagingElement<?> parentElement, Artifact grandparentArtifact, CompositePackagingElement<?> grandparentElement) {
            this.myParentArtifact = parentArtifact;
            this.myParentElement = parentElement;
            this.myGrandparentArtifact = grandparentArtifact;
            this.myGrandparentElement = grandparentElement;
        }

        public Artifact getParentArtifact() {
            return this.myParentArtifact;
        }

        public CompositePackagingElement<?> getParentElement() {
            return this.myParentElement;
        }

        public Artifact getGrandparentArtifact() {
            return this.myGrandparentArtifact;
        }

        public CompositePackagingElement<?> getGrandparentElement() {
            return this.myGrandparentElement;
        }
    }
}

