/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

class TableItem {
    private final String myUrl;
    private final CellAppearanceEx myCellAppearance;

    TableItem(@NotNull VirtualFile file) {
        this.myUrl = file.getUrl();
        this.myCellAppearance = FileAppearanceService.getInstance().forVirtualFile(file);
    }

    TableItem(@NotNull String url) {
        this.myUrl = url;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        this.myCellAppearance = file != null ? FileAppearanceService.getInstance().forVirtualFile(file) : FileAppearanceService.getInstance().forInvalidUrl(url);
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public CellAppearanceEx getCellAppearance() {
        return this.myCellAppearance;
    }
}

