/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.FileIntPropertyPusher;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelPusher
implements FileIntPropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 3, true);

    public static void pushLanguageLevel(@NotNull Project project) {
        PushedFilePropertiesUpdater instance = PushedFilePropertiesUpdater.getInstance((Project)project);
        for (FilePropertyPusher pusher : EP_NAME.getExtensionList()) {
            if (!(pusher instanceof JavaLanguageLevelPusher)) continue;
            instance.pushAll(new FilePropertyPusher[]{pusher});
        }
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        return LanguageLevel.KEY;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        return LanguageLevel.HIGHEST;
    }

    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        return null;
    }

    public LanguageLevel getImmediateValue(@NotNull Module module) {
        return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        return ProjectFileIndex.SERVICE.getInstance((Project)project).isInSourceContent(file);
    }

    @NotNull
    public FileAttribute getAttribute() {
        return PERSISTENCE;
    }

    public int toInt(@NotNull LanguageLevel languageLevel) {
        return languageLevel.ordinal();
    }

    @NotNull
    public LanguageLevel fromInt(int val) {
        return LanguageLevel.values()[val];
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel actualProperty) {
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !JavaLanguageLevelPusher.isJavaLike(child.getFileType())) continue;
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(child);
        }
    }

    private static boolean isJavaLike(FileType type2) {
        return type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message2, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        return null;
    }

    @Nullable
    public static LanguageLevel getPushedLanguageLevel(@NotNull VirtualFile file) {
        LanguageLevel level;
        VirtualFile parent = file.getParent();
        if (parent != null && (level = (LanguageLevel)parent.getUserData(LanguageLevel.KEY)) != null) {
            return level;
        }
        return null;
    }
}

