/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class JavaProjectRootsUtil {
    public static boolean isOutsideJavaSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        if (file.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) && !projectFileIndex.isInLibrary(file);
    }

    @NotNull
    public static List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            JavaProjectRootsUtil.collectSuitableDestinationSourceRoots(module, roots);
        }
        return roots;
    }

    public static void collectSuitableDestinationSourceRoots(@NotNull Module module, @NotNull List<? super VirtualFile> result) {
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder sourceFolder : entry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                if (JavaProjectRootsUtil.isForGeneratedSources(sourceFolder)) continue;
                ContainerUtil.addIfNotNull(result, (Object)sourceFolder.getFile());
            }
        }
    }

    public static boolean isForGeneratedSources(@NotNull SourceFolder sourceFolder) {
        JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        JavaResourceRootProperties resourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        return properties != null && properties.isForGeneratedSources() || resourceProperties != null && resourceProperties.isForGeneratedSources();
    }

    public static boolean isInGeneratedCode(@NotNull VirtualFile file, @NotNull Project project) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(file);
        if (module == null || module.isDisposed()) {
            return false;
        }
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot == null) {
            return false;
        }
        SourceFolder folder = ProjectRootsUtil.findSourceFolder((Module)module, (VirtualFile)sourceRoot);
        return folder != null && JavaProjectRootsUtil.isForGeneratedSources(folder);
    }

    @NotNull
    public static GlobalSearchScope getScopeWithoutGeneratedSources(@NotNull GlobalSearchScope baseScope, @NotNull Project project) {
        return new NonGeneratedSourceScope(baseScope, project);
    }

    @NotNull
    public static Map<OrderEntry, OrderEntry> findExportedDependenciesReachableViaThisDependencyOnly(@NotNull Module module, @NotNull Module dependency, @NotNull RootModelProvider rootModelProvider) {
        ModuleOrderEntry moduleOrderEntry = OrderEntryUtil.findModuleOrderEntry((ModuleRootModel)rootModelProvider.getRootModel(module), (Module)dependency);
        if (moduleOrderEntry == null) {
            throw new IllegalArgumentException("Cannot find dependency from " + module + " to " + dependency);
        }
        Condition withoutThisDependency = entry -> !(entry instanceof ModuleOrderEntry) || !entry.getOwnerModule().equals(module) || !dependency.equals(((ModuleOrderEntry)entry).getModule());
        OrderEnumerator enumerator = rootModelProvider.getRootModel(module).orderEntries().satisfying(withoutThisDependency).using(rootModelProvider).compileOnly().recursively().exportedOnly();
        if (moduleOrderEntry.getScope().isForProductionCompile()) {
            enumerator = enumerator.productionOnly();
        }
        HashSet reachableModules = new HashSet();
        HashSet reachableLibraries = new HashSet();
        enumerator.forEach(entry -> {
            if (entry instanceof ModuleSourceOrderEntry) {
                reachableModules.add(entry.getOwnerModule());
            } else if (entry instanceof ModuleOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)reachableModules, (Object)((ModuleOrderEntry)entry).getModule());
            } else if (entry instanceof LibraryOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)reachableLibraries, (Object)((LibraryOrderEntry)entry).getLibrary());
            }
            return true;
        });
        LinkedHashMap<OrderEntry, OrderEntry> result = new LinkedHashMap<OrderEntry, OrderEntry>();
        rootModelProvider.getRootModel(dependency).orderEntries().using(rootModelProvider).exportedOnly().withoutSdk().withoutModuleSourceEntries().forEach(direct -> {
            if (direct instanceof ModuleOrderEntry) {
                Module depModule = ((ModuleOrderEntry)direct).getModule();
                if (depModule != null && !reachableModules.contains(depModule)) {
                    result.put((OrderEntry)direct, (OrderEntry)direct);
                    rootModelProvider.getRootModel(depModule).orderEntries().using(rootModelProvider).exportedOnly().withoutSdk().recursively().forEach(transitive -> {
                        if ((transitive instanceof ModuleSourceOrderEntry && !reachableModules.contains(transitive.getOwnerModule()) && !depModule.equals(transitive.getOwnerModule()) || transitive instanceof LibraryOrderEntry && ((LibraryOrderEntry)transitive).getLibrary() != null && !reachableLibraries.contains(((LibraryOrderEntry)transitive).getLibrary())) && !result.containsKey(transitive)) {
                            result.put((OrderEntry)transitive, (OrderEntry)direct);
                        }
                        return true;
                    });
                }
            } else if (direct instanceof LibraryOrderEntry && ((LibraryOrderEntry)direct).getLibrary() != null && !reachableLibraries.contains(((LibraryOrderEntry)direct).getLibrary())) {
                result.put((OrderEntry)direct, (OrderEntry)direct);
            }
            return true;
        });
        return result;
    }

    private static class NonGeneratedSourceScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final Project myProject;

        private NonGeneratedSourceScope(@NotNull GlobalSearchScope baseScope, @NotNull Project project) {
            super(baseScope);
            this.myProject = project;
        }

        public boolean contains(@NotNull VirtualFile file) {
            return super.contains(file) && !JavaProjectRootsUtil.isInGeneratedCode(file, this.myProject);
        }
    }
}

