/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.project.PackagingModifiableModel;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingModifiableModelImpl
implements PackagingModifiableModel {
    private final Project myProject;
    private final IdeModifiableModelsProvider myModelsProvider;
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;

    public PackagingModifiableModelImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        this.myProject = project;
        this.myModelsProvider = modifiableModelsProvider;
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.myModelsProvider instanceof IdeUIModifiableModelsProvider ? ((IdeUIModifiableModelsProvider)this.myModelsProvider).getModifiableArtifactModel() : this.doGetModifiableArtifactModel();
        }
        return this.myModifiableArtifactModel;
    }

    private ModifiableArtifactModel doGetModifiableArtifactModel() {
        return (ModifiableArtifactModel)ReadAction.compute(() -> {
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
            return artifactManager != null ? artifactManager.createModifiableModel() : new DummyArtifactModel();
        });
    }

    @NotNull
    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    public void commit() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.commit();
        }
    }

    public void dispose() {
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
    }

    private static class DummyArtifactModel
    implements ModifiableArtifactModel {
        private DummyArtifactModel() {
        }

        @NotNull
        public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
            throw new UnsupportedOperationException();
        }

        public void removeArtifact(@NotNull Artifact artifact) {
        }

        @NotNull
        public ModifiableArtifact getOrCreateModifiableArtifact(@NotNull Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Artifact getModifiableCopy(Artifact artifact) {
            return null;
        }

        public void addListener(@NotNull ArtifactListener listener) {
        }

        public void removeListener(@NotNull ArtifactListener listener) {
        }

        public boolean isModified() {
            return false;
        }

        public void commit() {
        }

        public void dispose() {
        }

        public Artifact @NotNull [] getArtifacts() {
            return new Artifact[0];
        }

        @Nullable
        public Artifact findArtifact(@NotNull String name2) {
            return null;
        }

        @NotNull
        public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type2) {
            throw new UnsupportedOperationException();
        }

        public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        public Facet @NotNull [] getAllFacets(Module module) {
            return PackagingModifiableModelImpl.this.myModelsProvider.getModifiableFacetModel(module).getAllFacets();
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type2) {
            return PackagingModifiableModelImpl.this.myModelsProvider.getModifiableFacetModel(module).getFacetsByType(type2);
        }

        public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type2, String name2) {
            return (F)PackagingModifiableModelImpl.this.myModelsProvider.getModifiableFacetModel(module).findFacet(type2, name2);
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        public Module @NotNull [] getModules() {
            return PackagingModifiableModelImpl.this.myModelsProvider.getModules();
        }

        public Module getModule(@NotNull String name2) {
            return PackagingModifiableModelImpl.this.myModelsProvider.findIdeModule(name2);
        }

        public ModuleRootModel getRootModel(@NotNull Module module) {
            return PackagingModifiableModelImpl.this.myModelsProvider.getModifiableRootModel(module);
        }

        @NotNull
        public FacetModel getFacetModel(@NotNull Module module) {
            return PackagingModifiableModelImpl.this.myModelsProvider.getModifiableFacetModel(module);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider(this);
        }

        @NotNull
        public Project getProject() {
            return PackagingModifiableModelImpl.this.myProject;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            return PackagingModifiableModelImpl.this.getModifiableArtifactModel();
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            return this.myModulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            return this.myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level.equals("project")) {
                return PackagingModifiableModelImpl.this.myModelsProvider.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, PackagingModifiableModelImpl.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            return this.myManifestFileProvider;
        }
    }
}

