/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ForkedDebuggerThread;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskDebugRunner
extends GenericDebuggerRunner {
    static final Logger LOG = Logger.getInstance(ExternalSystemTaskDebugRunner.class);
    private static final String ATTACH_VM_FAILED = "ATTACH_VM_FAILED";

    @Override
    @NotNull
    public String getRunnerId() {
        return "ExternalSystemTaskDebugRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        return profile instanceof ExternalSystemRunConfiguration && "Debug".equals(executorId);
    }

    @Override
    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state instanceof ExternalSystemRunnableState) {
            ExternalSystemRunnableState myRunnableState = (ExternalSystemRunnableState)state;
            int port = myRunnableState.getDebugPort();
            if (port > 0) {
                RunContentDescriptor runContentDescriptor = this.doGetRunContentDescriptor(myRunnableState, environment);
                if (runContentDescriptor == null) {
                    return null;
                }
                ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
                ServerSocket socket = myRunnableState.getForkSocket();
                if (socket != null && processHandler != null) {
                    new ForkedDebuggerThread(processHandler, runContentDescriptor, socket, environment.getProject()).start();
                }
                return runContentDescriptor;
            }
            LOG.warn("Can't attach debugger to external system task execution. Reason: target debug port is unknown");
        } else {
            LOG.warn(String.format("Can't attach debugger to external system task execution. Reason: invalid run profile state is provided- expected '%s' but got '%s'", ExternalSystemRunnableState.class.getName(), state.getClass().getName()));
        }
        return null;
    }

    @Nullable
    private RunContentDescriptor doGetRunContentDescriptor(@NotNull ExternalSystemRunnableState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor runContentDescriptor = this.createProcessToDebug(state, environment);
        if (runContentDescriptor == null) {
            return null;
        }
        state.setContentDescriptor(runContentDescriptor);
        ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
        if (executionConsole instanceof BuildView) {
            return runContentDescriptor;
        }
        RunContentDescriptor descriptor = new RunContentDescriptor(runContentDescriptor.getExecutionConsole(), runContentDescriptor.getProcessHandler(), runContentDescriptor.getComponent(), runContentDescriptor.getDisplayName(), runContentDescriptor.getIcon(), null, runContentDescriptor.getRestartActions()){

            public boolean isHiddenContent() {
                return true;
            }
        };
        descriptor.setRunnerLayoutUi(runContentDescriptor.getRunnerLayoutUi());
        return descriptor;
    }

    @NotNull
    private XDebugProcess jvmProcessToDebug(@NotNull XDebugSession session, ExternalSystemRunnableState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", String.valueOf(state.getDebugPort()), true);
        DefaultDebugEnvironment environment = new DefaultDebugEnvironment(env, (RunProfileState)state, connection, 30000L);
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(env.getProject()).attachVirtualMachine(environment);
        if (debuggerSession == null) {
            throw new ExecutionException(ATTACH_VM_FAILED);
        }
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
        ExecutionResult executionResult = debugProcess.getExecutionResult();
        sessionImpl.addExtraActions(executionResult.getActions());
        if (executionResult instanceof DefaultExecutionResult) {
            sessionImpl.addRestartActions(((DefaultExecutionResult)executionResult).getRestartActions());
        }
        return JavaDebugProcess.create(session, debuggerSession);
    }

    @Nullable
    private RunContentDescriptor createProcessToDebug(final ExternalSystemRunnableState state, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunContentDescriptor result;
        try {
            result = XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                    XDebugProcess nonJvmDebugProcess = state.startDebugProcess(session, env);
                    return nonJvmDebugProcess != null ? nonJvmDebugProcess : ExternalSystemTaskDebugRunner.this.jvmProcessToDebug(session, state, env);
                }
            }).getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            if (!e.getMessage().equals(ATTACH_VM_FAILED)) {
                throw e;
            }
            result = null;
        }
        return result;
    }
}

