/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.request;

import com.intellij.lang.java.actions.JvmPsiUtilKt;
import com.intellij.lang.java.request.CreateFieldFromJavaUsageRequest;
import com.intellij.lang.java.request.CreateFieldFromUsage;
import com.intellij.lang.java.request.CreateFromUsageUtilsKt;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0011J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/java/request/CreateFieldRequests;", "", "myRef", "Lcom/intellij/psi/PsiReferenceExpression;", "(Lcom/intellij/psi/PsiReferenceExpression;)V", "getMyRef", "()Lcom/intellij/psi/PsiReferenceExpression;", "requests", "Ljava/util/LinkedHashMap;", "Lcom/intellij/lang/jvm/JvmClass;", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "Lkotlin/collections/LinkedHashMap;", "addRequest", "", "target", "request", "collectRequests", "", "doCollectRequests", "processClass", "staticContext", "", "processHierarchy", "baseClass", "Lcom/intellij/psi/PsiClass;", "processOuterAndImported", "intellij.java.impl"})
final class CreateFieldRequests {
    private final LinkedHashMap<JvmClass, CreateFieldRequest> requests;
    @NotNull
    private final PsiReferenceExpression myRef;

    @NotNull
    public final Map<JvmClass, CreateFieldRequest> collectRequests() {
        this.doCollectRequests();
        return this.requests;
    }

    private final void addRequest(JvmClass target, CreateFieldRequest request) {
        if (target instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)((PsiElement)target));
        }
        ((Map)this.requests).put(target, request);
    }

    private final void doCollectRequests() {
        PsiExpression qualifier = this.myRef.getQualifierExpression();
        if (qualifier != null) {
            PsiClass instanceClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
            if (instanceClass != null) {
                this.processHierarchy(instanceClass);
            } else {
                PsiClass staticClass;
                PsiExpression psiExpression = qualifier;
                if (!(psiExpression instanceof PsiJavaCodeReferenceElement)) {
                    psiExpression = null;
                }
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)psiExpression;
                Object object = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
                if (!(object instanceof PsiClass)) {
                    object = null;
                }
                if ((staticClass = (PsiClass)object) != null) {
                    this.processClass((JvmClass)staticClass, true);
                }
            }
        } else {
            PsiSwitchLabelStatementBase psiSwitchLabelStatementBase = PsiImplUtil.getSwitchLabel((PsiExpression)this.myRef);
            PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly(psiSwitchLabelStatementBase != null && (psiSwitchLabelStatementBase = psiSwitchLabelStatementBase.getEnclosingSwitchStatement()) != null && (psiSwitchLabelStatementBase = psiSwitchLabelStatementBase.getExpression()) != null ? psiSwitchLabelStatementBase.getType() : null);
            if (baseClass != null) {
                this.processHierarchy(baseClass);
            } else {
                this.processOuterAndImported();
            }
        }
    }

    private final void processHierarchy(PsiClass baseClass) {
        for (PsiClass clazz : CreateFromUsageUtilsKt.hierarchy(baseClass)) {
            this.processClass((JvmClass)clazz, false);
        }
    }

    private final void processOuterAndImported() {
        boolean inStaticContext = CreateFromUsageUtilsKt.isInStaticContext((PsiExpression)this.myRef);
        for (PsiClass outerClass : CreateFromUsageUtilsKt.collectOuterClasses((PsiElement)this.myRef)) {
            this.processClass((JvmClass)outerClass, inStaticContext);
        }
        for (JvmClass imported : CreateFieldFromUsage.access$collectOnDemandImported((PsiElement)this.myRef)) {
            this.processClass(imported, true);
        }
    }

    private final void processClass(JvmClass target, boolean staticContext) {
        boolean bl;
        boolean bl2;
        JvmModifier jvmModifier;
        if (!staticContext && ArraysKt.contains((Object[])CreateFieldFromUsage.access$getSTATIC_ONLY$p(), (Object)target.getClassKind())) {
            return;
        }
        boolean bl3 = false;
        Set modifiers = new LinkedHashSet();
        if (staticContext) {
            Collection collection = modifiers;
            jvmModifier = JvmModifier.STATIC;
            bl2 = false;
            collection.add(jvmModifier);
        }
        if (CreateFieldFromUsage.access$shouldCreateFinalField(this.myRef, target)) {
            Collection collection = modifiers;
            jvmModifier = JvmModifier.FINAL;
            bl2 = false;
            collection.add(jvmModifier);
        }
        PsiElement $this$parentOfType$iv = (PsiElement)this.myRef;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType = false;
        PsiClass ownerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiClass.class, (boolean)true);
        JvmModifier visibility = CreateFromUsageUtilsKt.computeVisibility(this.myRef.getProject(), ownerClass, target);
        if (visibility != null) {
            Collection withSelf$iv2 = modifiers;
            bl = false;
            withSelf$iv2.add(visibility);
        }
        bl = false;
        boolean bl4 = Intrinsics.areEqual((Object)JvmPsiUtilKt.toJavaClassOrNull(target), (Object)ownerClass);
        PsiReferenceExpression psiReferenceExpression = this.myRef;
        Collection collection = modifiers;
        CreateFieldFromJavaUsageRequest request = new CreateFieldFromJavaUsageRequest(psiReferenceExpression, collection, bl, bl4);
        this.addRequest(target, request);
    }

    @NotNull
    public final PsiReferenceExpression getMyRef() {
        return this.myRef;
    }

    public CreateFieldRequests(@NotNull PsiReferenceExpression myRef) {
        this.myRef = myRef;
        this.requests = new LinkedHashMap();
    }
}

