/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.google.common.collect.HashMultiset;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance(JavaImportOptimizer.class);

    @NotNull
    public Runnable processFile(final @NotNull PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return EmptyRunnable.getInstance();
        }
        Project project = file.getProject();
        final PsiImportList newImportList = JavaCodeStyleManager.getInstance((Project)project).prepareOptimizeImportsResult((PsiJavaFile)file);
        if (newImportList == null) {
            return EmptyRunnable.getInstance();
        }
        return new ImportOptimizer.CollectingInfoRunnable(){
            private int myImportsAdded;
            private int myImportsRemoved;

            public void run() {
                try {
                    PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
                    Document document = manager.getDocument(file);
                    if (document != null) {
                        manager.commitDocument(document);
                    }
                    PsiImportList oldImportList = ((PsiJavaFile)file).getImportList();
                    assert (oldImportList != null);
                    HashMultiset oldImports = HashMultiset.create();
                    for (PsiImportStatement statement : oldImportList.getImportStatements()) {
                        oldImports.add((Object)statement.resolve());
                    }
                    HashMultiset oldStaticImports = HashMultiset.create();
                    for (PsiImportStaticStatement psiImportStaticStatement : oldImportList.getImportStaticStatements()) {
                        oldStaticImports.add((Object)psiImportStaticStatement.resolve());
                    }
                    oldImportList.replace((PsiElement)newImportList);
                    for (PsiImportStaticStatement psiImportStaticStatement : newImportList.getImportStatements()) {
                        if (oldImports.remove((Object)psiImportStaticStatement.resolve())) continue;
                        ++this.myImportsAdded;
                    }
                    this.myImportsRemoved += oldImports.size();
                    for (PsiImportStaticStatement psiImportStaticStatement : newImportList.getImportStaticStatements()) {
                        if (oldStaticImports.remove((Object)psiImportStaticStatement.resolve())) continue;
                        ++this.myImportsAdded;
                    }
                    this.myImportsRemoved += oldStaticImports.size();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public String getUserNotificationInfo() {
                if (this.myImportsRemoved == 0) {
                    return "rearranged imports";
                }
                StringBuilder notification = new StringBuilder("removed ").append(this.myImportsRemoved).append(" import");
                if (this.myImportsRemoved > 1) {
                    notification.append('s');
                }
                if (this.myImportsAdded > 0) {
                    notification.append(", added ").append(this.myImportsAdded).append(" import");
                    if (this.myImportsAdded > 1) {
                        notification.append('s');
                    }
                }
                return notification.toString();
            }
        };
    }

    public boolean supports(@NotNull PsiFile file) {
        return file instanceof PsiJavaFile && !TemplateLanguageUtil.isTemplateDataFile((PsiFile)file) && ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex().isInSource(file.getViewProvider().getVirtualFile());
    }
}

