/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.bintray;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.bintray.BintrayEndpoint;
import com.intellij.jarRepository.services.bintray.BintrayModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BintrayRepositoryService
extends MavenRepositoryService {
    @Override
    @NotNull
    public String getDisplayName() {
        return "Bintray";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        BintrayModel.Repository info = BintrayRepositoryService.parseInfo(url);
        if (info != null) {
            BintrayEndpoint bintrayEndpoint = new BintrayEndpoint();
            if (info.repo != null) {
                RemoteRepositoryDescription repository = bintrayEndpoint.getRepository(info.subject, info.repo);
                return repository == null ? Collections.emptyList() : Collections.singletonList(repository);
            }
            return bintrayEndpoint.getRepositories(info.subject);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        BintrayModel.Repository info;
        if ((template.getPackaging() == null || template.getPackaging().equals("jar")) && (info = BintrayRepositoryService.parseInfo(url)) != null) {
            BintrayEndpoint bintrayEndpoint = new BintrayEndpoint();
            if (StringUtil.isNotEmpty((String)template.getClassNames())) {
                return bintrayEndpoint.getArtifacts(info.subject, info.repo, template.getClassNames());
            }
            List artifacts = bintrayEndpoint.getArtifacts(info.subject, info.repo, template.getGroupId(), template.getArtifactId());
            if (!StringUtil.isEmpty((String)template.getVersion())) {
                String versionTemplate = StringUtil.trimStart((String)StringUtil.trimEnd((String)template.getVersion(), (String)"*"), (String)"*");
                artifacts = ContainerUtil.filter(artifacts, a -> !a.getVersion().contains(versionTemplate));
            }
            return artifacts;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static BintrayModel.Repository parseInfo(String url) {
        try {
            URL theUrl = new URL(url);
            String host = theUrl.getHost();
            if (host != null) {
                List path = StringUtil.split((String)StringUtil.trimStart((String)theUrl.getPath(), (String)"/"), (String)"/");
                if (host.equals("dl.bintray.com")) {
                    if (!path.isEmpty()) {
                        return new BintrayModel.Repository((String)path.get(0), path.size() > 1 ? (String)path.get(1) : null);
                    }
                } else {
                    if (host.equals("jcenter.bintray.com")) {
                        return new BintrayModel.Repository("bintray", "jcenter");
                    }
                    if (host.endsWith(".bintray.com")) {
                        return new BintrayModel.Repository(StringUtil.trimEnd((String)host, (String)".bintray.com"), path.isEmpty() ? null : (String)path.get(0));
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

