/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.artifactory;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.artifactory.ArtifactoryModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactoryRepositoryService
extends MavenRepositoryService {
    private final Gson gson = new Gson();

    @Override
    @NotNull
    public String getDisplayName() {
        return "Artifactory";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            ArtifactoryModel.RepositoryType[] repos = (ArtifactoryModel.RepositoryType[])this.gson.fromJson(HttpRequests.request((Url)this.toUrl(url, "repositories")).productNameAsUserAgent().readString(), ArtifactoryModel.RepositoryType[].class);
            ArrayList<RemoteRepositoryDescription> result = new ArrayList<RemoteRepositoryDescription>(repos.length);
            for (ArtifactoryModel.RepositoryType repo : repos) {
                result.add(ArtifactoryRepositoryService.convert(repo));
            }
            return result;
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static RemoteRepositoryDescription convert(ArtifactoryModel.RepositoryType repo) {
        return new RemoteRepositoryDescription(repo.key, (String)ObjectUtils.notNull((Object)repo.description, (Object)repo.key), repo.url);
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            String className2 = template.getClassNames();
            if (className2 == null || className2.length() == 0) {
                return this.searchArtifacts(url, template);
            }
            return this.searchArchives(url, template);
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private List<RepositoryArtifactDescription> searchArchives(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        String packaging = StringUtil.notNullize((String)template.getPackaging());
        ArrayList<RepositoryArtifactDescription> artifacts = new ArrayList<RepositoryArtifactDescription>();
        String className2 = template.getClassNames();
        String searchString = className2.endsWith("*") || className2.endsWith("?") ? className2 : className2 + ".class";
        Url requestUrl = this.toUrl(url, "search/archive", "name=" + URLEncoder.encode(searchString.trim(), "UTF-8"));
        ArtifactoryModel.ArchiveResults results = (ArtifactoryModel.ArchiveResults)this.gson.fromJson(HttpRequests.request((Url)requestUrl).productNameAsUserAgent().readString(), ArtifactoryModel.ArchiveResults.class);
        if (results != null && results.results != null) {
            for (ArtifactoryModel.ArchiveResult result : results.results) {
                for (String uri : result.archiveUris) {
                    if (!uri.endsWith(packaging)) continue;
                    artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(uri, url, result.entry));
                }
            }
        }
        return artifacts;
    }

    @NotNull
    private List<RepositoryArtifactDescription> searchArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        String packaging = StringUtil.notNullize((String)template.getPackaging());
        ArrayList<RepositoryArtifactDescription> artifacts = new ArrayList<RepositoryArtifactDescription>();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("g", template.getGroupId());
        params.put("a", template.getArtifactId());
        params.put("v", template.getVersion());
        params.put("repos", "");
        Url requestUrl = this.toUrl(url, "search/gavc", this.mapToParamString(params));
        ArtifactoryModel.GavcResults results = (ArtifactoryModel.GavcResults)this.gson.fromJson(HttpRequests.request((Url)requestUrl).productNameAsUserAgent().readString(), ArtifactoryModel.GavcResults.class);
        if (results != null && results.results != null) {
            for (ArtifactoryModel.GavcResult result : results.results) {
                if (!result.uri.endsWith(packaging)) continue;
                artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(result.uri, url, null));
            }
        }
        return artifacts;
    }

    private static RepositoryArtifactDescription convertArtifactInfo(String uri, String baseUri, String className2) {
        int repoIndex;
        String repoPathFile = uri.substring((baseUri + "storage/").length());
        String repoString = repoPathFile.substring(0, repoIndex = repoPathFile.indexOf(47));
        String repo = repoString.endsWith("-cache") ? repoString.substring(0, repoString.lastIndexOf(45)) : repoString;
        String filePath = repoPathFile.substring(repoIndex + 1, repoPathFile.lastIndexOf(47));
        int artIdIndex = filePath.lastIndexOf(47);
        String version = filePath.substring(artIdIndex + 1);
        String groupArtifact = filePath.substring(0, artIdIndex);
        int groupIndex = groupArtifact.lastIndexOf(47);
        String artifact = groupArtifact.substring(groupIndex + 1);
        String group = groupArtifact.substring(0, groupIndex).replace('/', '.');
        String packaging = uri.substring(uri.lastIndexOf(46) + 1);
        return new RepositoryArtifactDescription(group, artifact, version, packaging, null, className2, repo);
    }
}

