/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.index;

import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.flavor.FileIndexingFlavorProvider;
import com.intellij.util.indexing.flavor.HashBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileIndexingFlavor
implements FileIndexingFlavorProvider<CharSequence> {
    @Nullable
    public CharSequence getFlavor(@NotNull IndexedFile file) {
        VirtualFile vFile = file.getFile();
        VirtualFileSystem fs = vFile.getFileSystem();
        if (!(fs instanceof JarFileSystem)) {
            return null;
        }
        VirtualFile root = ((JarFileSystem)fs).getRootByEntry(vFile);
        return root == null ? null : root.getNameSequence();
    }

    public void buildHash(@NotNull CharSequence archiveName, @NotNull HashBuilder hashBuilder) {
        hashBuilder.putString(archiveName);
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public String getId() {
        return "ClassFileIndexingFlavor";
    }
}

