/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeViewUtil {
    private static final int SUBPACKAGE_LIMIT = 2;
    private static final Key<ConcurrentMap<PsiPackage, Boolean>> SHOULD_ABBREV_PACK_KEY = Key.create((String)"PACK_ABBREV_CACHE");

    private static boolean shouldAbbreviateName(PsiPackage aPackage) {
        Boolean ret;
        ConcurrentMap newMap;
        Project project = aPackage.getProject();
        ConcurrentMap map2 = (ConcurrentMap)project.getUserData(SHOULD_ABBREV_PACK_KEY);
        if (map2 == null && (map2 = (ConcurrentMap)((UserDataHolderEx)project).putUserDataIfAbsent(SHOULD_ABBREV_PACK_KEY, (Object)(newMap = ContainerUtil.createConcurrentWeakMap()))) == newMap) {
            PsiManagerEx.getInstanceEx((Project)project).registerRunnableToRunOnChange(() -> newMap.clear());
        }
        if ((ret = (Boolean)map2.get(aPackage)) != null) {
            return ret;
        }
        ret = TreeViewUtil.scanPackages(aPackage, 1);
        map2.put(aPackage, ret);
        return ret;
    }

    private static boolean scanPackages(@NotNull PsiPackage p, int packageNameOccurrencesFound) {
        PsiPackage[] subPackages = p.getSubPackages();
        if ((packageNameOccurrencesFound += subPackages.length) > 2) {
            return true;
        }
        for (PsiPackage subPackage : subPackages) {
            if (!TreeViewUtil.scanPackages(subPackage, packageNameOccurrencesFound)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String calcAbbreviatedPackageFQName(@NotNull PsiPackage aPackage) {
        String packageName;
        StringBuilder name2 = new StringBuilder(aPackage.getName());
        for (PsiPackage parentPackage = aPackage.getParentPackage(); parentPackage != null && (packageName = parentPackage.getName()) != null && !packageName.isEmpty(); parentPackage = parentPackage.getParentPackage()) {
            name2.insert(0, ".");
            if (packageName.length() > 2 && TreeViewUtil.shouldAbbreviateName(parentPackage)) {
                name2.insert(0, packageName.charAt(0));
                continue;
            }
            name2.insert(0, packageName);
        }
        return name2.toString();
    }

    public static boolean isEmptyMiddlePackage(@NotNull PsiDirectory dir, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter) {
        VirtualFile[] files = dir.getVirtualFile().getChildren();
        if (files.length == 0) {
            return false;
        }
        PsiManager manager = dir.getManager();
        int subpackagesCount = 0;
        int directoriesCount = 0;
        for (VirtualFile file : files) {
            PsiDirectory childDir;
            if (FileTypeManager.getInstance().isFileIgnored(file)) continue;
            if (!file.isDirectory()) {
                if (filter == null) {
                    return false;
                }
                PsiFile childFile = manager.findFile(file);
                if (childFile != null && filter.shouldShow((PsiFileSystemItem)childFile)) {
                    return false;
                }
            }
            if ((childDir = manager.findDirectory(file)) == null || filter != null && !filter.shouldShow((PsiFileSystemItem)childDir)) continue;
            if (strictlyEmpty && ++directoriesCount > 1) {
                return false;
            }
            if (JavaDirectoryService.getInstance().getPackage(childDir) == null) continue;
            ++subpackagesCount;
        }
        if (strictlyEmpty) {
            return directoriesCount == subpackagesCount && directoriesCount == 1;
        }
        return directoriesCount == subpackagesCount && directoriesCount > 0;
    }
}

