/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.java.JavaBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    public static final Key<PsiMethod[]> SIBLINGS = Key.create((String)"MULTIPLE_INHERITANCE");

    private SuperMethodWarningUtil() {
    }

    public static PsiMethod @NotNull [] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return SuperMethodWarningUtil.checkSuperMethods(method, actionString, Collections.emptyList());
    }

    public static PsiMethod @NotNull [] getTargetMethodCandidates(@NotNull PsiMethod method, @NotNull Collection<? extends PsiElement> ignore) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return new PsiMethod[]{method};
        }
        Collection<PsiMethod> superMethods = SuperMethodWarningUtil.getSuperMethods(method, aClass, ignore);
        if (superMethods.isEmpty()) {
            return new PsiMethod[]{method};
        }
        return superMethods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    public static PsiMethod @NotNull [] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString, @NotNull Collection<? extends PsiElement> ignore) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiMethod[] methodTargetCandidates = SuperMethodWarningUtil.getTargetMethodCandidates(method, ignore);
        if (methodTargetCandidates.length == 1 && methodTargetCandidates[0] == method) {
            return methodTargetCandidates;
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : methodTargetCandidates) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        int shouldIncludeBase = SuperMethodWarningUtil.showDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, superAbstract, parentInterface, method.getContainingClass().isInterface(), ArrayUtilRt.toStringArray(superClasses));
        switch (shouldIncludeBase) {
            case 0: {
                return methodTargetCandidates;
            }
            case 1: {
                return new PsiMethod[]{method};
            }
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    static Collection<PsiMethod> getSuperMethods(@NotNull PsiMethod method, PsiClass aClass, @NotNull Collection<? extends PsiElement> ignore) {
        VirtualFile virtualFile;
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        superMethods.removeAll(ignore);
        if (superMethods.isEmpty() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass)) != null && ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInSourceContent(virtualFile)) {
            PsiMethod[] siblingSuperMethod = new PsiMethod[1];
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                siblingSuperMethod[0] = (PsiMethod)ReadAction.compute(() -> FindSuperElementsHelper.getSiblingInheritedViaSubClass(method));
            }, JavaBundle.message((String)"progress.title.searching.for.sub.classes", (Object[])new Object[0]), true, aClass.getProject())) {
                throw new ProcessCanceledException();
            }
            if (siblingSuperMethod[0] != null) {
                superMethods.add(siblingSuperMethod[0]);
                superMethods.add(method);
            }
        }
        return superMethods;
    }

    public static PsiMethod checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return method;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            return method;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        int useSuperMethod = SuperMethodWarningUtil.showDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        switch (useSuperMethod) {
            case 0: {
                return superMethod;
            }
            case 1: {
                return method;
            }
        }
        return null;
    }

    public static void checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString, @NotNull PsiElementProcessor<? super PsiMethod> processor2, @NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        PsiMethod[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            processor2.execute((PsiElement)method);
            return;
        }
        PsiClass containingClass = superMethods[0].getContainingClass();
        if (containingClass == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor2.execute((PsiElement)superMethods[0]);
            return;
        }
        PsiMethod[] methods = new PsiMethod[]{superMethods[0], method};
        String renameBase = actionString + " base method" + (superMethods.length > 1 ? "s" : "");
        String renameCurrent = actionString + " only current method";
        String title = method.getName() + (superMethods.length > 1 ? " has super methods" : (containingClass.isInterface() && !aClass.isInterface() ? " implements" : " overrides") + " method of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass));
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])new String[]{renameBase, renameCurrent})).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> {
            if (value2.equals(renameBase)) {
                try {
                    methods[0].putUserData(SIBLINGS, (Object)superMethods);
                    processor2.execute((PsiElement)methods[0]);
                }
                finally {
                    methods[0].putUserData(SIBLINGS, null);
                }
            } else {
                processor2.execute((PsiElement)methods[1]);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Messages.YesNoCancelResult
    private static int showDialog(@NotNull Project project, @NotNull String name2, @NotNull String actionString, boolean isSuperAbstract, boolean isParentInterface, boolean isContainedInInterface, String ... classNames) {
        String message2 = SuperMethodWarningUtil.getDialogMessage(name2, actionString, isSuperAbstract, isParentInterface, isContainedInInterface, classNames);
        return Messages.showYesNoCancelDialog((Project)project, (String)message2, (String)JavaBundle.message((String)"dialog.title.super.method.found", (Object[])new Object[0]), (String)JavaBundle.message((String)"button.base.method", (Object[])new Object[0]), (String)JavaBundle.message((String)"button.current.method", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
    }

    @NotNull
    private static String getDialogMessage(@NotNull String name2, @NotNull String actionString, boolean isSuperAbstract, boolean isParentInterface, boolean isContainedInInterface, String @NotNull [] classNames) {
        StringBuilder labelText = new StringBuilder();
        String classType = isParentInterface ? JavaBundle.message((String)"element.of.interface", (Object[])new Object[0]) : JavaBundle.message((String)"element.of.class", (Object[])new Object[0]);
        String methodString = JavaPsiBundle.message((String)"element.method", (Object[])new Object[0]);
        labelText.append("<html>").append(JavaBundle.message((String)"label.method", (Object[])new Object[]{name2})).append("<br>");
        if (classNames.length == 1) {
            String className2 = classNames[0];
            labelText.append(isContainedInInterface || !isSuperAbstract ? JavaBundle.message((String)"label.overrides.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className2}) : JavaBundle.message((String)"label.implements.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className2}));
            labelText.append("<br>");
        } else {
            labelText.append(JavaBundle.message((String)"label.implements.method.of_interfaces", (Object[])new Object[0]));
            for (String className3 : classNames) {
                labelText.append("<br>&emsp;'").append(className3).append("'");
            }
        }
        labelText.append("<br>");
        labelText.append(JavaBundle.message((String)"prompt.do.you.want.to.action_verb.the.method.from_class", (Object[])new Object[]{actionString, classNames.length}));
        return labelText.toString();
    }
}

