/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiMemberNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiMethodNode
extends BasePsiMemberNode<PsiMethod> {
    public PsiMethodNode(Project project, @NotNull PsiMethod value2, @NotNull ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        return null;
    }

    public void updateImpl(@NotNull PresentationData data) {
        String name2;
        PsiMethod method = (PsiMethod)this.getValue();
        assert (method != null);
        try {
            name2 = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2);
        }
        catch (IndexNotReadyException e) {
            name2 = method.getName();
        }
        int c = name2.indexOf(10);
        if (c > -1) {
            name2 = name2.substring(0, c - 1);
        }
        data.setPresentableText(name2);
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public boolean isConstructor() {
        PsiMethod psiMethod = (PsiMethod)this.getValue();
        return psiMethod != null && psiMethod.isConstructor();
    }

    public int getWeight() {
        return this.isConstructor() ? 40 : 50;
    }

    public String getTitle() {
        PsiMethod method = (PsiMethod)this.getValue();
        if (method != null) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                return aClass.getQualifiedName();
            }
            return method.toString();
        }
        return super.getTitle();
    }
}

