/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageElementNode
extends ProjectViewNode<PackageElement>
implements ValidateableNode {
    public PackageElementNode(@NotNull Project project, @NotNull PackageElement value2, ViewSettings viewSettings) {
        super(project, (Object)value2, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        PsiDirectory[] directories;
        if (!this.isUnderContent(file) || this.getValue() == null) {
            return false;
        }
        for (PsiDirectory directory : directories = ((PackageElement)this.getValue()).getPackage().getDirectories()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnderContent(VirtualFile file) {
        Module module;
        PackageElement element = (PackageElement)this.getValue();
        Module module2 = module = element == null ? null : element.getModule();
        if (module == null) {
            return ModuleUtilCore.projectContainsFile((Project)this.getProject(), (VirtualFile)file, (boolean)this.isLibraryElement());
        }
        return ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file, (boolean)this.isLibraryElement());
    }

    private boolean isLibraryElement() {
        return this.getValue() != null && ((PackageElement)this.getValue()).isLibraryElement();
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        PsiFile[] packageChildren;
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            return Collections.emptyList();
        }
        ArrayList children = new ArrayList();
        Module module = value2.getModule();
        PsiPackage aPackage = value2.getPackage();
        if (!this.getSettings().isFlattenPackages()) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, this.isLibraryElement())) {
                PackageUtil.addPackageAsChild(children, subpackage, module, this.getSettings(), this.isLibraryElement());
            }
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, this.isLibraryElement());
        for (PsiFile file : packageChildren = aPackage.getFiles(scopeToShow)) {
            if (file.getVirtualFile() == null) continue;
            children.add((AbstractTreeNode<?>)new PsiFileNode(this.getProject(), file, this.getSettings()));
        }
        return children;
    }

    public boolean validate() {
        return super.validate() && this.isValid();
    }

    public boolean isValid() {
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 != null && value2.getPackage().isValid()) {
            Module module = value2.getModule();
            return module == null || !module.isDisposed();
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        try {
            if (this.isValid()) {
                this.updateValidData(presentation, (PackageElement)this.getValue());
                return;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        this.setValue(null);
    }

    private void updateValidData(PresentationData presentation, PackageElement value2) {
        PsiPackage aPackage = value2.getPackage();
        if (!this.getSettings().isFlattenPackages() && this.getSettings().isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, value2.getModule(), true, this.isLibraryElement())) {
            this.setValue(null);
            return;
        }
        PsiPackage parentPackage = this.getParentPackage();
        String qName = aPackage.getQualifiedName();
        String name2 = PackageUtil.getNodeName(this.getSettings(), aPackage, parentPackage, qName, this.showFQName(aPackage));
        presentation.setPresentableText(name2);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        if (this.myProject != null) {
            CompoundProjectViewNodeDecorator.get((Project)this.myProject).decorate((ProjectViewNode)this, presentation);
        }
    }

    private boolean showFQName(PsiPackage aPackage) {
        return this.getSettings().isFlattenPackages() && !aPackage.getQualifiedName().isEmpty();
    }

    public String getTestPresentation() {
        PresentationData presentation = new PresentationData();
        this.update(presentation);
        return "PsiPackage: " + presentation.getPresentableText();
    }

    public boolean valueIsCut() {
        return this.getValue() != null && CopyPasteManager.getInstance().isCutElement((Object)((PackageElement)this.getValue()).getPackage());
    }

    public VirtualFile @NotNull [] getVirtualFiles() {
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiDirectory[] directories = PackageUtil.getDirectories(value2.getPackage(), value2.getModule(), this.isLibraryElement());
        VirtualFile[] result = new VirtualFile[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            result[i] = directory.getVirtualFile();
        }
        return result;
    }

    public boolean canRepresent(Object element) {
        VirtualFile file;
        String aPackage;
        PackageElement packageElement;
        String otherPackage;
        if (super.canRepresent(element)) {
            return true;
        }
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            return true;
        }
        if (element instanceof PackageElement && (otherPackage = (packageElement = (PackageElement)element).getPackage().getQualifiedName()).equals(aPackage = value2.getPackage().getQualifiedName())) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return this.isPackageUnderDirectory(value2, directory.getVirtualFile());
        }
        if (element instanceof VirtualFile && (file = (VirtualFile)element).isDirectory()) {
            return this.isPackageUnderDirectory(value2, file);
        }
        return false;
    }

    private boolean isPackageUnderDirectory(@NotNull PackageElement element, @NotNull VirtualFile file) {
        PsiPackage parent = this.getParentPackage();
        for (PsiPackage p = element.getPackage(); p != null && !p.equals(parent); p = p.getParentPackage()) {
            for (PsiDirectory directory : p.getDirectories()) {
                if (!directory.getVirtualFile().equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    private PsiPackage getParentPackage() {
        Object value2 = this.getParentValue();
        return value2 instanceof PackageElement ? ((PackageElement)value2).getPackage() : null;
    }

    public int getWeight() {
        return 0;
    }

    public String getTitle() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement == null) {
            return super.getTitle();
        }
        return packageElement.getPackage().getQualifiedName();
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement != null) {
            return packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 4;
    }

    public boolean isAlwaysShowPlus() {
        for (VirtualFile dir : this.getVirtualFiles()) {
            if (dir.getChildren().length <= 0) continue;
            return true;
        }
        return false;
    }
}

