/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePackageMacro
extends Macro {
    @NotNull
    public String getName() {
        return "FilePackage";
    }

    @NotNull
    public String getDescription() {
        return JavaBundle.message((String)"macro.file.package", (Object[])new Object[0]);
    }

    public String expand(@NotNull DataContext dataContext) {
        PsiPackage aPackage = FilePackageMacro.getFilePackage(dataContext);
        if (aPackage == null) {
            return null;
        }
        return aPackage.getName();
    }

    @Nullable
    static PsiPackage getFilePackage(DataContext dataContext) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return null;
        }
        PsiDirectory containingDirectory = psiFile.getContainingDirectory();
        if (containingDirectory == null || !containingDirectory.isValid()) {
            return null;
        }
        return JavaDirectoryService.getInstance().getPackage(containingDirectory);
    }
}

