/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallReferenceProcessor;
import com.intellij.ide.hierarchy.call.JavaCallHierarchyData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class CallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CallerMethodsTreeStructure(@NotNull Project project, @NotNull PsiMember member, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new CallHierarchyNodeDescriptor(project, null, (PsiElement)member, true, false));
        this.myScopeType = scopeType;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public CallerMethodsTreeStructure(@NotNull Project project, @NotNull PsiMethod method, String scopeType) {
        this(project, (PsiMember)method, scopeType);
    }

    protected final Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiMember baseMember;
        PsiClass clazz;
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        if (enclosingElement == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        HierarchyNodeDescriptor nodeDescriptor = this.getBaseDescriptor();
        if (nodeDescriptor == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        if (enclosingElement instanceof PsiMethod && CallerMethodsTreeStructure.isLocalOrAnonymousClass((PsiMember)(clazz = enclosingElement.getContainingClass()))) {
            PsiElement grandParent;
            PsiElement parent = clazz.getParent();
            PsiElement psiElement = grandParent = parent instanceof PsiNewExpression ? parent.getParent() : null;
            if (grandParent instanceof PsiExpressionList) {
                enclosingElement = CallHierarchyNodeDescriptor.getEnclosingElement(grandParent);
            }
        }
        if ((baseMember = (PsiMember)((CallHierarchyNodeDescriptor)nodeDescriptor).getTargetElement()) == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)baseMember.getContainingClass());
        PsiMember member = enclosingElement;
        PsiClass originalClass = member.getContainingClass();
        if (originalClass == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        PsiClassType originalType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(originalClass);
        HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        if (enclosingElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)enclosingElement;
            methodsToFind.add(method);
            ContainerUtil.addAll(methodsToFind, (Object[])method.findDeepestSuperMethods());
            HashMap methodToDescriptorMap = new HashMap();
            for (PsiMethod methodToFind : methodsToFind) {
                JavaCallHierarchyData data = new JavaCallHierarchyData(originalClass, methodToFind, originalType, method, methodsToFind, (NodeDescriptor)descriptor, methodToDescriptorMap, this.myProject);
                MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                    if (!PsiUtil.isInsideJavadocComment((PsiElement)reference.getElement())) {
                        for (CallReferenceProcessor processor2 : (CallReferenceProcessor[])CallReferenceProcessor.EP_NAME.getExtensions()) {
                            if (!processor2.process(reference, data)) break;
                        }
                    }
                    return true;
                });
            }
            return ArrayUtil.toObjectArray(methodToDescriptorMap.values());
        }
        assert (enclosingElement instanceof PsiField) : "Enclosing element should be a field, but was " + enclosingElement.getClass() + ", text: " + enclosingElement.getText();
        return ReferencesSearch.search((PsiElement)enclosingElement, (SearchScope)enclosingElement.getUseScope()).findAll().stream().map(PsiReference::getElement).distinct().map(e -> new CallHierarchyNodeDescriptor(this.myProject, nodeDescriptor, (PsiElement)e, false, false)).toArray();
    }

    private static boolean isLocalOrAnonymousClass(PsiMember enclosingElement) {
        return enclosingElement instanceof PsiClass && ((PsiClass)enclosingElement).getQualifiedName() == null;
    }

    public String toString() {
        return "Caller Hierarchy for " + this.formatBaseElementText();
    }
}

