/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.smartPointerPsiNodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

abstract class BaseSmartPointerPsiNode<Type extends SmartPsiElementPointer>
extends ProjectViewNode<Type>
implements PsiElementNavigationItem {
    private static final Logger LOG = Logger.getInstance(BasePsiNode.class);

    BaseSmartPointerPsiNode(@NotNull Project project, @NotNull Type value2, @NotNull ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @NotNull
    public final Collection<AbstractTreeNode<?>> getChildren() {
        PsiElement value2 = this.getPsiElement();
        if (value2 == null) {
            return new ArrayList();
        }
        LOG.assertTrue(value2.isValid());
        return this.getChildrenImpl();
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode<?>> getChildrenImpl();

    private boolean isMarkReadOnly() {
        Object parentValue = this.getParentValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof PackageElement;
    }

    public PsiElement getTargetElement() {
        VirtualFile file = this.getVirtualFileForValue();
        return PsiUtilCore.findFileSystemItem((Project)this.getProject(), (VirtualFile)file);
    }

    private VirtualFile getVirtualFileForValue() {
        PsiElement value2 = this.getPsiElement();
        if (value2 == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)value2);
    }

    protected abstract void updateImpl(@NotNull PresentationData var1);

    public void update(@NotNull PresentationData data) {
        PsiElement value2 = this.getPsiElement();
        if (value2 == null || !value2.isValid()) {
            this.setValue(null);
        }
        if (value2 == null) {
            return;
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        LOG.assertTrue(value2.isValid());
        Icon icon = value2.getIcon(flags);
        data.setIcon(icon);
        data.setPresentableText(this.myName);
        if (this.isDeprecated()) {
            data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        }
        this.updateImpl(data);
        if (this.myProject != null) {
            CompoundProjectViewNodeDecorator.get((Project)this.myProject).decorate((ProjectViewNode)this, data);
        }
    }

    private boolean isDeprecated() {
        try {
            PsiElement psiElement = this.getPsiElement();
            return psiElement instanceof PsiDocCommentOwner && psiElement.isValid() && ((PsiDocCommentOwner)psiElement).isDeprecated();
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        return file.equals(containingFile.getVirtualFile());
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            ((NavigationItem)this.getPsiElement()).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        PsiElement psiElement = this.getPsiElement();
        return psiElement instanceof NavigationItem && ((NavigationItem)psiElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        PsiElement psiElement = this.getPsiElement();
        return psiElement instanceof NavigationItem && ((NavigationItem)psiElement).canNavigateToSource();
    }

    protected PsiElement getPsiElement() {
        return (PsiElement)this.getValue();
    }
}

