/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework;

import com.intellij.framework.FrameworkGroup;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.PossiblyDumbAware;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkTypeEx
extends FrameworkType
implements PossiblyDumbAware {
    public static final ExtensionPointName<FrameworkTypeEx> EP_NAME = ExtensionPointName.create((String)"com.intellij.framework.type");

    protected FrameworkTypeEx(@NotNull String id) {
        super(id);
    }

    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public FrameworkGroup<?> getParentGroup() {
        return null;
    }

    @Nullable
    @Contract(pure=true)
    public String getUnderlyingFrameworkTypeId() {
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public abstract FrameworkSupportInModuleProvider createProvider();

    @Contract(pure=true)
    public <V extends FrameworkVersion> List<V> getVersions() {
        return Collections.emptyList();
    }

    public FrameworkRole[] getRoles() {
        FrameworkRole[] frameworkRoleArray;
        FrameworkGroup<?> parentGroup = this.getParentGroup();
        if (parentGroup == null) {
            FrameworkSupportInModuleProvider provider;
            String id = this.getUnderlyingFrameworkTypeId();
            if (id != null && (provider = FrameworkSupportUtil.findProvider(id)) != null) {
                return provider.getRoles();
            }
            return FrameworkRole.UNKNOWN;
        }
        FrameworkRole role = parentGroup.getRole();
        if (null == role) {
            frameworkRoleArray = FrameworkRole.UNKNOWN;
        } else {
            FrameworkRole[] frameworkRoleArray2 = new FrameworkRole[1];
            frameworkRoleArray = frameworkRoleArray2;
            frameworkRoleArray2[0] = role;
        }
        return frameworkRoleArray;
    }
}

