/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTreeModel {
    private static final Logger LOG = Logger.getInstance(FacetTreeModel.class);
    private static final FacetInfo ROOT = new FacetInfo(null, "", null, null);
    private final List<FacetInfo> myFacetInfos = new ArrayList<FacetInfo>();
    private final BidirectionalMap<FacetInfo, FacetInfo> myParents = new BidirectionalMap();

    public void addFacetInfo(FacetInfo info) {
        this.myFacetInfos.add(info);
        this.myParents.put((Object)info, (Object)FacetTreeModel.null2Root(info.getUnderlyingFacet()));
    }

    @NotNull
    private static FacetInfo null2Root(@Nullable FacetInfo info) {
        return info == null ? ROOT : info;
    }

    @Nullable
    private static FacetInfo root2Null(@NotNull FacetInfo info) {
        return info == ROOT ? null : info;
    }

    public FacetInfo[] getFacetInfos() {
        return this.myFacetInfos.toArray(FacetInfo.EMPTY_ARRAY);
    }

    public void removeFacetInfo(@NotNull FacetInfo info) {
        boolean removed = this.myFacetInfos.remove(info);
        LOG.assertTrue(removed);
        this.myParents.remove((Object)info);
    }

    @Nullable
    public FacetInfo getParent(@NotNull FacetInfo info) {
        return FacetTreeModel.root2Null((FacetInfo)this.myParents.get((Object)info));
    }

    @NotNull
    public List<FacetInfo> getChildren(@Nullable FacetInfo info) {
        List list = this.myParents.getKeysByValue((Object)FacetTreeModel.null2Root(info));
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public List<FacetInfo> getTopLevelFacets() {
        return this.getChildren(null);
    }

    @Nullable
    public FacetInfo findNearestFacet(@NotNull FacetInfo info) {
        FacetInfo parent = this.getParent(info);
        List<FacetInfo> children = this.getChildren(parent);
        int index = children.indexOf(info);
        if (index < children.size() - 1) {
            return children.get(index + 1);
        }
        if (index > 0) {
            return children.get(index - 1);
        }
        return parent;
    }

    public boolean hasFacetOfType(@Nullable FacetInfo parent, FacetTypeId typeId) {
        List<FacetInfo> list = this.getChildren(parent);
        for (FacetInfo info : list) {
            if (info.getFacetType().getId() != typeId) continue;
            return true;
        }
        return false;
    }

    public Collection<FacetInfo> getFacetInfos(FacetType<?, ?> type2) {
        FacetInfo[] facetInfos = this.getFacetInfos();
        ArrayList<FacetInfo> infos = new ArrayList<FacetInfo>();
        for (FacetInfo facetInfo : facetInfos) {
            if (!facetInfo.getFacetType().equals(type2)) continue;
            infos.add(facetInfo);
        }
        return infos;
    }
}

