/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serialization.PropertyMapping;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaProjectData
extends AbstractExternalEntityData {
    public static final Key<JavaProjectData> KEY = Key.create(JavaProjectData.class, (int)(ProjectKeys.PROJECT.getProcessingWeight() + 1));
    private static final Logger LOG = Logger.getInstance(JavaProjectData.class);
    private static final Pattern JDK_VERSION_PATTERN = Pattern.compile(".*1.(\\d+).*");
    private boolean isSetJdkVersion = false;
    @NotNull
    private JavaSdkVersion jdkVersion;
    @NotNull
    private String compileOutputPath;
    @NotNull
    private LanguageLevel languageLevel;
    @Nullable
    private String targetBytecodeVersion;

    public JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath) {
        this(owner2, compileOutputPath, null, null);
    }

    @PropertyMapping(value={"owner", "compileOutputPath", "languageLevel", "targetBytecodeVersion"})
    public JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath, @Nullable LanguageLevel languageLevel, @Nullable String targetBytecodeVersion) {
        this(owner2, compileOutputPath, null, languageLevel, targetBytecodeVersion);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public @NotNull JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath, @Nullable JavaSdkVersion jdkVersion, @Nullable LanguageLevel languageLevel, @Nullable String targetBytecodeVersion) {
        super(owner2);
        this.compileOutputPath = compileOutputPath;
        this.jdkVersion = jdkVersion != null ? jdkVersion : JavaSdkVersion.fromLanguageLevel((LanguageLevel)LanguageLevel.HIGHEST);
        this.languageLevel = languageLevel != null ? languageLevel : LanguageLevel.HIGHEST;
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    @NotNull
    public String getCompileOutputPath() {
        return this.compileOutputPath;
    }

    public void setCompileOutputPath(@NotNull String compileOutputPath) {
        this.compileOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)compileOutputPath);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public JavaSdkVersion getJdkVersion() {
        return this.jdkVersion;
    }

    @ApiStatus.Internal
    public boolean isSetJdkVersion() {
        return this.isSetJdkVersion;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setJdkVersion(@NotNull JavaSdkVersion jdkVersion) {
        this.isSetJdkVersion = true;
        this.jdkVersion = jdkVersion;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setJdkVersion(@Nullable String jdk) {
        JavaSdkVersion sdkVersion = JavaProjectData.resolveSdkVersion(jdk);
        if (sdkVersion == null) {
            return;
        }
        this.setJdkVersion(sdkVersion);
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static JavaSdkVersion resolveSdkVersion(@Nullable String jdk) {
        if (jdk == null) {
            return null;
        }
        try {
            int version = Integer.parseInt(jdk.trim());
            JavaSdkVersion sdkVersion = JavaProjectData.resolveSdkVersion(version);
            if (sdkVersion != null) {
                return sdkVersion;
            }
        }
        catch (NumberFormatException version) {
            // empty catch block
        }
        Matcher matcher = JDK_VERSION_PATTERN.matcher(jdk);
        if (!matcher.matches()) {
            return null;
        }
        String versionAsString = matcher.group(1);
        try {
            return JavaProjectData.resolveSdkVersion(Integer.parseInt(versionAsString));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    private static JavaSdkVersion resolveSdkVersion(int version) {
        if (version < 0 || version >= JavaSdkVersion.values().length) {
            LOG.warn(String.format("Unsupported jdk version detected (%d). Expected to get number from range [0; %d]", version, JavaSdkVersion.values().length));
            return null;
        }
        for (JavaSdkVersion sdkVersion : JavaSdkVersion.values()) {
            if (sdkVersion.ordinal() != version) continue;
            return sdkVersion;
        }
        assert (false) : version + ", max value: " + JavaSdkVersion.values().length;
        return null;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel level) {
        this.languageLevel = level;
    }

    public void setLanguageLevel(@Nullable String languageLevel) {
        LanguageLevel level = LanguageLevel.parse((String)languageLevel);
        if (level != null) {
            this.languageLevel = level;
        }
    }

    @Nullable
    public String getTargetBytecodeVersion() {
        return this.targetBytecodeVersion;
    }

    public void setTargetBytecodeVersion(@Nullable String targetBytecodeVersion) {
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.jdkVersion);
        result = 31 * result + this.languageLevel.hashCode();
        result = 31 * result + Objects.hashCode(this.targetBytecodeVersion);
        result = 31 * result + this.compileOutputPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaProjectData project = (JavaProjectData)((Object)o);
        if (!this.compileOutputPath.equals(project.compileOutputPath)) {
            return false;
        }
        if (Objects.equals(this.jdkVersion, project.jdkVersion)) {
            return false;
        }
        if (Objects.equals(this.languageLevel, project.languageLevel)) {
            return false;
        }
        return !Objects.equals(this.targetBytecodeVersion, project.targetBytecodeVersion);
    }

    public String toString() {
        return "java project";
    }
}

