/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarApplicationConfigurationProducer
extends LazyRunConfigurationProducer<JarApplicationConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return JarApplicationConfigurationType.getInstance();
    }

    protected boolean setupConfigurationFromContext(@NotNull JarApplicationConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile file = JarApplicationConfigurationProducer.getJarFileFromContext(context);
        if (file != null) {
            configuration.setName(file.getName());
            configuration.setJarPath(file.getPath());
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getJarFileFromContext(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        VirtualFile file = location.getVirtualFile();
        return file != null && FileUtilRt.extensionEquals((String)file.getName(), (String)"jar") ? file : null;
    }

    public boolean isConfigurationFromContext(@NotNull JarApplicationConfiguration configuration, @NotNull ConfigurationContext context) {
        VirtualFile file = JarApplicationConfigurationProducer.getJarFileFromContext(context);
        return file != null && FileUtil.pathsEqual((String)file.getPath(), (String)configuration.getJarPath());
    }
}

