/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.feedbacks.AlphaFeedback;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JComponent;

public class MarqueeTracker
extends InputTool {
    private static final Color myColor = new Color(47, 67, 96);
    private static final int TOGGLE_MODE = 1;
    private static final int APPEND_MODE = 2;
    private JComponent myFeedback;
    private int mySelectionMode;
    private boolean mySelectBackground;

    public MarqueeTracker() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    public void setSelectBackground(boolean selectBackground) {
        this.mySelectBackground = selectBackground;
    }

    @Override
    protected void handleButtonDown(int button) {
        if (button == 1 || button == 2) {
            if (this.myState == 1) {
                this.myState = 2;
                if (this.myInputEvent.isControlDown()) {
                    this.mySelectionMode = 1;
                } else if (this.myInputEvent.isShiftDown()) {
                    this.mySelectionMode = 2;
                }
            }
        } else {
            this.myState = 4;
            this.eraseFeedback();
        }
        if (button != 3) {
            this.refreshCursor();
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.myState == 3) {
            this.myState = 0;
            this.eraseFeedback();
            this.performMarqueeSelect();
        } else if (this.mySelectBackground) {
            this.performMarqueeSelect();
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 2) {
            this.myState = 3;
            this.refreshCursor();
        }
        if (this.myState == 3) {
            this.showFeedback();
        }
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        boolean changedModifiers = event.getModifiers() != this.myModifiers;
        super.keyPressed(event, area);
        if (changedModifiers) {
            this.showFeedback();
        }
    }

    @Override
    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        boolean changedModifiers = event.getModifiers() != this.myModifiers;
        super.keyReleased(event, area);
        if (changedModifiers) {
            this.showFeedback();
        }
    }

    @Override
    public void deactivate() {
        if (this.myState == 3) {
            this.eraseFeedback();
        }
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 3) {
            return this.getDefaultCursor();
        }
        if (this.myState == 4) {
            return this.getDisabledCursor();
        }
        return null;
    }

    private void showFeedback() {
        FeedbackLayer layer = this.myArea.getFeedbackLayer();
        if (this.myFeedback == null) {
            this.myFeedback = new AlphaFeedback(myColor);
            layer.add(this.myFeedback);
        }
        this.myFeedback.setBounds(this.getSelectionRectangle());
        if (ApplicationManager.getApplication().isInternal()) {
            Dimension size = this.myFeedback.getSize();
            this.myArea.setDescription("Size [" + size.width + " : " + size.height + "]");
        }
        layer.repaint();
    }

    protected void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myArea.getFeedbackLayer();
            layer.remove(this.myFeedback);
            layer.repaint();
            this.myFeedback = null;
        }
    }

    private Rectangle getSelectionRectangle() {
        if (this.isAltOptionPressed()) {
            int deltaX = Math.abs(this.myStartScreenX - this.myCurrentScreenX);
            int deltaY = Math.abs(this.myStartScreenY - this.myCurrentScreenY);
            return new Rectangle(this.myStartScreenX - deltaX, this.myStartScreenY - deltaY, 2 * deltaX, 2 * deltaY);
        }
        return new Rectangle(this.myStartScreenX, this.myStartScreenY, 0, 0).union(new Rectangle(this.myCurrentScreenX, this.myCurrentScreenY, 0, 0));
    }

    private void performMarqueeSelect() {
        final Rectangle selectionRectangle = this.getSelectionRectangle();
        final ArrayList<RadComponent> newSelection = new ArrayList<RadComponent>();
        RadComponent rootComponent = this.myArea.getRootComponent();
        if (rootComponent != null) {
            rootComponent.accept(new RadComponentVisitor(){

                @Override
                public void endVisit(RadComponent component) {
                    if (selectionRectangle.contains(component.getBounds(MarqueeTracker.this.myArea.getNativeComponent())) && !component.isBackground()) {
                        newSelection.add(component);
                    }
                }
            }, true);
            if (newSelection.isEmpty() && this.mySelectBackground) {
                rootComponent.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent component) {
                        if (newSelection.isEmpty() && component.getBounds(MarqueeTracker.this.myArea.getNativeComponent()).contains(selectionRectangle.x, selectionRectangle.y) && component.isBackground()) {
                            newSelection.add(component);
                        }
                    }
                }, true);
            }
        }
        if (this.mySelectionMode == 1) {
            ArrayList<RadComponent> selection = new ArrayList<RadComponent>(this.myArea.getSelection());
            for (RadComponent component : newSelection) {
                int index = selection.indexOf((Object)component);
                if (index == -1) {
                    selection.add(component);
                    continue;
                }
                selection.remove(index);
            }
            this.myArea.setSelection(selection);
        } else if (this.mySelectionMode == 2) {
            for (RadComponent component : newSelection) {
                this.myArea.appendSelection(component);
            }
        } else {
            this.myArea.setSelection(newSelection);
        }
    }
}

