/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.inspection.AbstractQuickFixManager;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.RadComponent;
import com.intellij.icons.AllIcons;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;

public final class QuickFixManager
extends AbstractQuickFixManager
implements ComponentSelectionListener {
    public QuickFixManager(DesignerEditorPanel designer, JComponent component, JViewport viewPort) {
        super(designer, component, viewPort);
        designer.getSurfaceArea().addSelectionListener(this);
    }

    @Override
    public void selectionChanged(EditableArea area) {
        this.hideHint();
        this.updateHintVisibility();
    }

    @Override
    @NotNull
    protected List<ErrorInfo> getErrorInfos() {
        List<RadComponent> selection = this.myDesigner.getSurfaceArea().getSelection();
        if (selection.size() == 1) {
            return RadComponent.getError(selection.get(0));
        }
        return Collections.emptyList();
    }

    @Override
    protected Rectangle getErrorBounds() {
        List<RadComponent> selection = this.myDesigner.getSurfaceArea().getSelection();
        if (selection.size() == 1) {
            Rectangle bounds = selection.get(0).getBounds(this.myComponent);
            bounds.x -= AllIcons.Actions.IntentionBulb.getIconWidth() - 5;
            return bounds;
        }
        return null;
    }

    @Override
    protected Rectangle getHintClipRect() {
        Rectangle clipRect = super.getHintClipRect();
        clipRect.grow(4, 4);
        return clipRect;
    }
}

