/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.model.RadComponent;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.util.ArrayUtilRt;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

public class ExpandStateHandler
implements TreeExpansionListener {
    private final ComponentTree myTree;
    private final DesignerEditorPanel myDesigner;
    private final AbstractTreeBuilder myTreeBuilder;

    public ExpandStateHandler(ComponentTree tree, DesignerEditorPanel designer, AbstractTreeBuilder treeBuilder) {
        this.myTree = tree;
        this.myDesigner = designer;
        this.myTreeBuilder = treeBuilder;
    }

    public void hookListener() {
        this.myTree.addTreeExpansionListener(this);
    }

    public void unhookListener() {
        this.myTree.removeTreeExpansionListener(this);
    }

    public Object[] getExpanded() {
        List<?> components = this.myDesigner.getExpandedComponents();
        return components == null ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : components.toArray();
    }

    private void setExpanded() {
        List elements = this.myTreeBuilder.getUi().getExpandedElements();
        Iterator I = elements.iterator();
        while (I.hasNext()) {
            Object element = I.next();
            if (element instanceof RadComponent) continue;
            I.remove();
        }
        this.myDesigner.setExpandedComponents(elements);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.setExpanded();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.setExpanded();
    }
}

