/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectSameTypeAction
extends AnAction {
    private final EditableArea myArea;

    public SelectSameTypeAction(EditableArea area) {
        super("Select Same Type", "Select Same Type", null);
        this.myArea = area;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RadComponent rootComponent = this.myArea.getRootComponent();
        if (rootComponent != null) {
            final List<RadComponent> selection = this.myArea.getSelection();
            final ArrayList<RadComponent> components = new ArrayList<RadComponent>();
            rootComponent.accept(new RadComponentVisitor(){

                @Override
                public void endVisit(RadComponent component) {
                    if (!component.isBackground()) {
                        for (RadComponent selected : selection) {
                            if (!selected.isSameType(component)) continue;
                            components.add(component);
                            break;
                        }
                    }
                }
            }, true);
            this.myArea.setSelection(components);
        }
    }
}

