/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"AlternativeSource");
    private static final Key<Boolean> FILE_PROCESSED_KEY = Key.create((String)"AlternativeSourceCheckDone");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        XDebugSession session;
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        DebuggerSession javaSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
        XDebugSession xDebugSession = session = javaSession != null ? javaSession.getXDebugSession() : null;
        if (session == null) {
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            return null;
        }
        XSourcePosition position = session.getCurrentPosition();
        if (position == null || !file.equals(position.getFile())) {
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes2 = ((PsiJavaFile)psiFile).getClasses();
        if (classes2.length == 0) {
            return null;
        }
        PsiClass baseClass = classes2[0];
        String name2 = baseClass.getQualifiedName();
        if (name2 == null) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        ArrayList alts = ContainerUtil.newArrayList((Object[])JavaPsiFacade.getInstance((Project)project).findClasses(name2, javaSession.getSearchScope()));
        ContainerUtil.removeDuplicates((Collection)alts);
        AlternativeSourceNotificationProvider.setFileProcessed(file, true);
        if (alts.size() > 1) {
            Location location;
            for (PsiClass cls : alts) {
                if (!cls.equals(baseClass) && !cls.getNavigationElement().equals(baseClass)) continue;
                alts.remove(cls);
                break;
            }
            alts.add(0, baseClass);
            ComboBoxClassElement[] elems = (ComboBoxClassElement[])ContainerUtil.map2Array((Collection)alts, ComboBoxClassElement.class, psiClass -> new ComboBoxClassElement((PsiClass)psiClass.getNavigationElement()));
            String locationDeclName = null;
            XStackFrame frame = session.getCurrentStackFrame();
            if (frame instanceof JavaStackFrame && (location = ((JavaStackFrame)frame).getDescriptor().getLocation()) != null) {
                locationDeclName = location.declaringType().name();
            }
            return new AlternativeSourceNotificationPanel(elems, baseClass, project, file, locationDeclName);
        }
        return null;
    }

    public static boolean isFileProcessed(VirtualFile file) {
        return FILE_PROCESSED_KEY.get((UserDataHolder)file) != null;
    }

    public static void setFileProcessed(VirtualFile file, boolean value2) {
        FILE_PROCESSED_KEY.set((UserDataHolder)file, (Object)(value2 ? Boolean.TRUE : null));
    }

    private static class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        AlternativeSourceNotificationPanel(ComboBoxClassElement[] alternatives, PsiClass aClass, final Project project, final VirtualFile file, final String locationDeclName) {
            this.setText(JavaDebuggerBundle.message((String)"editor.notification.alternative.source", (Object[])new Object[]{aClass.getQualifiedName()}));
            final ComboBox switcher = new ComboBox((Object[])alternatives);
            switcher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
                    final DebuggerSession session = context.getDebuggerSession();
                    PsiClass item = ((ComboBoxClassElement)switcher.getSelectedItem()).myClass;
                    final VirtualFile vFile = item.getContainingFile().getVirtualFile();
                    if (session != null && vFile != null) {
                        session.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                            @Override
                            protected void action() {
                                if (!StringUtil.isEmpty((String)locationDeclName)) {
                                    DebuggerUtilsEx.setAlternativeSourceUrl(locationDeclName, vFile.getUrl(), project);
                                }
                                DebuggerUIUtil.invokeLater(() -> {
                                    FileEditorManager.getInstance((Project)project).closeFile(file);
                                    session.refresh(true);
                                });
                            }
                        });
                    } else {
                        FileEditorManager.getInstance((Project)project).closeFile(file);
                        item.navigate(true);
                    }
                }
            });
            this.myLinksPanel.add((Component)switcher);
            this.createActionLabel(JavaDebuggerBundle.message((String)"action.disable.text", (Object[])new Object[0]), () -> {
                DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
                AlternativeSourceNotificationProvider.setFileProcessed(file, false);
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                FileEditor editor = fileEditorManager.getSelectedEditor(file);
                if (editor != null) {
                    fileEditorManager.removeTopComponent(editor, (JComponent)((Object)this));
                }
            });
        }
    }

    private static class ComboBoxClassElement {
        private final PsiClass myClass;
        private String myText;
        private static final JList ourDummyList = new JBList();

        ComboBoxClassElement(PsiClass aClass) {
            this.myClass = aClass;
        }

        public String toString() {
            if (this.myText == null) {
                ModuleRendererFactory factory = ModuleRendererFactory.findInstance((Object)this.myClass);
                DefaultListCellRenderer moduleRenderer = factory.getModuleRenderer();
                moduleRenderer.getListCellRendererComponent((JList<?>)ourDummyList, this.myClass, 1, false, false);
                this.myText = moduleRenderer.getText();
            }
            return this.myText;
        }
    }
}

