/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerConsoleFilterProvider
implements ConsoleFilterProvider {
    public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
        return new Filter[]{new JavaDebuggerAttachFilter()};
    }

    private static class AttachInlayResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final String myTransport;
        private final String myAddress;

        AttachInlayResult(int highlightStartOffset, int highlightEndOffset, String transport, String address) {
            super(highlightStartOffset, highlightEndOffset, null);
            this.myTransport = transport;
            this.myAddress = address;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            PresentationFactory factory = new PresentationFactory((EditorImpl)editor);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText("Attach debugger")), (event, point) -> JavaAttachDebuggerProvider.attach(this.myTransport, this.myAddress, null, editor.getProject()));
            return new PresentationRenderer(presentation);
        }
    }

    private static class JavaDebuggerAttachFilter
    implements Filter {
        static final Pattern PATTERN = Pattern.compile("Listening for transport (\\S+) at address: (\\S+)");

        private JavaDebuggerAttachFilter() {
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.find()) {
                return null;
            }
            String transport = matcher.group(1);
            String address = matcher.group(2);
            int start = entireLength - line.length();
            return new Filter.Result(Arrays.asList(new Filter.ResultItem[]{new AttachInlayResult(start + matcher.start(), start + matcher.end(), transport, address), new Filter.ResultItem(0, 0, null)}));
        }
    }
}

