/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.NameMapper;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DebuggerManagerImpl
extends DebuggerManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DebuggerManagerImpl.class);
    public static final String LOCALHOST_ADDRESS_FALLBACK = "127.0.0.1";
    private final Project myProject;
    private final Map<ProcessHandler, DebuggerSession> mySessions = new HashMap<ProcessHandler, DebuggerSession>();
    private final BreakpointManager myBreakpointManager;
    private final List<NameMapper> myNameMappers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EventDispatcher<DebuggerManagerListener> myDispatcher = EventDispatcher.create(DebuggerManagerListener.class);
    private final MyDebuggerStateManager myDebuggerStateManager = new MyDebuggerStateManager();
    private final DebuggerContextListener mySessionListener = new DebuggerContextListener(){

        @Override
        public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
            DebuggerSession session = newContext.getDebuggerSession();
            if (event == DebuggerSession.Event.PAUSE && DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession != session) {
                DebuggerManagerImpl.this.myDebuggerStateManager.setState(newContext, session != null ? session.getState() : DebuggerSession.State.DISPOSED, event, null);
                return;
            }
            if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session) {
                DebuggerManagerImpl.this.myDebuggerStateManager.fireStateChanged(newContext, event);
            }
            if (event == DebuggerSession.Event.ATTACHED) {
                DebuggerManagerImpl.this.getEventPublisher().sessionAttached(session);
            } else if (event == DebuggerSession.Event.DETACHED) {
                DebuggerManagerImpl.this.getEventPublisher().sessionDetached(session);
            } else if (event == DebuggerSession.Event.DISPOSE) {
                DebuggerManagerImpl.this.dispose(session);
                if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session) {
                    DebuggerManagerImpl.this.myDebuggerStateManager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.DISPOSE, null);
                }
            }
        }
    };

    @NotNull
    private DebuggerManagerListener getEventPublisher() {
        return (DebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(DebuggerManagerListener.TOPIC);
    }

    public void addClassNameMapper(NameMapper mapper) {
        this.myNameMappers.add(mapper);
    }

    public void removeClassNameMapper(NameMapper mapper) {
        this.myNameMappers.remove(mapper);
    }

    public String getVMClassQualifiedName(@NotNull PsiClass aClass) {
        for (NameMapper nameMapper : this.myNameMappers) {
            String qName = nameMapper.getQualifiedName(aClass);
            if (qName == null) continue;
            return qName;
        }
        return aClass.getQualifiedName();
    }

    @Override
    public void addDebuggerManagerListener(@NotNull DebuggerManagerListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeDebuggerManagerListener(@NotNull DebuggerManagerListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public DebuggerManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myBreakpointManager = new BreakpointManager(this.myProject, this);
        MessageBusConnection busConnection = project.getMessageBus().connect();
        if (!project.isDefault()) {
            busConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme scheme) {
                    DebuggerManagerImpl.this.getBreakpointManager().updateBreakpointsUI();
                }
            });
            busConnection.subscribe(DebuggerManagerListener.TOPIC, (Object)this.myDispatcher.getMulticaster());
        }
        this.myBreakpointManager.addListeners(busConnection);
    }

    @Override
    @Nullable
    public DebuggerSession getSession(DebugProcess process2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSessions().stream().filter(debuggerSession -> process2 == debuggerSession.getProcess()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<DebuggerSession> getSessions() {
        Map<ProcessHandler, DebuggerSession> map2 = this.mySessions;
        synchronized (map2) {
            Collection<DebuggerSession> values = this.mySessions.values();
            return values.isEmpty() ? Collections.emptyList() : new ArrayList<DebuggerSession>(values);
        }
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.myBreakpointManager.writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.myBreakpointManager.readExternal(state);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myBreakpointManager.writeExternal(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DebuggerSession attachVirtualMachine(@NotNull DebugEnvironment environment) throws ExecutionException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessEvents debugProcess = new DebugProcessEvents(this.myProject);
        DebuggerSession session = DebuggerSession.create(debugProcess, environment);
        ExecutionResult executionResult = session.getProcess().getExecutionResult();
        if (executionResult == null) {
            return null;
        }
        session.getContextManager().addListener(this.mySessionListener);
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session, session.getContextManager().getContext().getSuspendContext()), session.getState(), DebuggerSession.Event.CONTEXT, null);
        ProcessHandler processHandler = executionResult.getProcessHandler();
        Map<ProcessHandler, DebuggerSession> map2 = this.mySessions;
        synchronized (map2) {
            this.mySessions.put(processHandler, session);
        }
        if (!(processHandler instanceof RemoteDebugProcessHandler)) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    ProcessHandler processHandler = event.getProcessHandler();
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.stop(willBeDestroyed && (!(processHandler instanceof KillableColoredProcessHandler) || !((KillableColoredProcessHandler)processHandler).shouldKillProcessSoftly()));
                        if (!DebuggerManagerThreadImpl.isManagerThread()) {
                            if (SwingUtilities.isEventDispatchThread()) {
                                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                                    debugProcess.waitFor(10000L);
                                }, JavaDebuggerBundle.message((String)"waiting.for.debugger.response", (Object[])new Object[0]), false, debugProcess.getProject());
                            } else {
                                debugProcess.waitFor(10000L);
                            }
                        }
                    }
                }
            });
        }
        this.getEventPublisher().sessionCreated(session);
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            session.dispose();
            return null;
        }
        if (environment.isRemote()) {
            debugProcess.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcessImpl getDebugProcess(ProcessHandler processHandler) {
        Map<ProcessHandler, DebuggerSession> map2 = this.mySessions;
        synchronized (map2) {
            DebuggerSession session = this.mySessions.get(processHandler);
            return session != null ? session.getProcess() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DebuggerSession getDebugSession(ProcessHandler processHandler) {
        Map<ProcessHandler, DebuggerSession> map2 = this.mySessions;
        synchronized (map2) {
            return this.mySessions.get(processHandler);
        }
    }

    public void addDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.addDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.addDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    public void removeDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.removeDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.removeDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    public boolean isDebuggerManagerThread() {
        return DebuggerManagerThreadImpl.isManagerThread();
    }

    @Override
    @NotNull
    public BreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    @Override
    @NotNull
    public DebuggerContextImpl getContext() {
        return this.getContextManager().getContext();
    }

    @Override
    @NotNull
    public DebuggerStateManager getContextManager() {
        return this.myDebuggerStateManager;
    }

    @Deprecated
    public static RemoteConnection createDebugParameters(JavaParameters parameters2, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity) throws ExecutionException {
        return new RemoteConnectionBuilder(debuggerInServerMode, transport, debugPort).checkValidity(checkValidity).asyncAgent(true).memoryAgent(DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(parameters2);
    }

    public static RemoteConnection createDebugParameters(JavaParameters parameters2, GenericDebuggerRunnerSettings settings, boolean checkValidity) throws ExecutionException {
        return new RemoteConnectionBuilder(settings.LOCAL, settings.getTransport(), settings.getDebugPort()).checkValidity(checkValidity).asyncAgent(true).memoryAgent(DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(parameters2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(DebuggerSession session) {
        ProcessHandler processHandler = session.getProcess().getProcessHandler();
        Map<ProcessHandler, DebuggerSession> map2 = this.mySessions;
        synchronized (map2) {
            DebuggerSession removed = this.mySessions.remove(processHandler);
            LOG.assertTrue(removed != null);
            this.getEventPublisher().sessionRemoved(session);
        }
    }

    public static class DebuggerRunContentWithExecutorListener
    implements RunContentWithExecutorListener {
        private final Project myProject;

        public DebuggerRunContentWithExecutorListener(Project project) {
            this.myProject = project;
        }

        public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
            if (executor == DefaultDebugExecutor.getDebugExecutorInstance()) {
                DebuggerSession session = descriptor == null ? null : this.getSession(descriptor);
                DebuggerStateManager manager = DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager();
                if (session != null) {
                    manager.setState(session.getContextManager().getContext(), session.getState(), DebuggerSession.Event.CONTEXT, null);
                } else {
                    manager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
                }
            }
        }

        private DebuggerSession getSession(RunContentDescriptor descriptor) {
            for (JavaDebugProcess process2 : XDebuggerManager.getInstance((Project)this.myProject).getDebugProcesses(JavaDebugProcess.class)) {
                if (!Comparing.equal((Object)process2.getProcessHandler(), (Object)descriptor.getProcessHandler())) continue;
                return process2.getDebuggerSession();
            }
            return null;
        }
    }

    private static class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerSession myDebuggerSession;

        private MyDebuggerStateManager() {
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            return this.myDebuggerSession == null ? DebuggerContextImpl.EMPTY_CONTEXT : this.myDebuggerSession.getContextManager().getContext();
        }

        @Override
        public void setState(@NotNull DebuggerContextImpl context, DebuggerSession.State state, DebuggerSession.Event event, String description) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myDebuggerSession = context.getDebuggerSession();
            if (this.myDebuggerSession != null) {
                this.myDebuggerSession.getContextManager().setState(context, state, event, description);
            } else {
                this.fireStateChanged(context, event);
            }
        }
    }
}

