/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreakpointHandler
extends XBreakpointHandler {
    protected final DebugProcessImpl myProcess;

    public JavaBreakpointHandler(@NotNull Class<? extends XBreakpointType<?, ?>> breakpointTypeClass, DebugProcessImpl process2) {
        super(breakpointTypeClass);
        this.myProcess = process2;
    }

    @Nullable
    protected Breakpoint createJavaBreakpoint(@NotNull XBreakpoint xBreakpoint) {
        return null;
    }

    public void registerBreakpoint(@NotNull XBreakpoint breakpoint) {
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint == null) {
            javaBreakpoint = this.createJavaBreakpoint(breakpoint);
            breakpoint.putUserData(Breakpoint.DATA_KEY, (Object)javaBreakpoint);
        }
        if (javaBreakpoint != null) {
            Breakpoint bpt = javaBreakpoint;
            BreakpointManager.addBreakpoint(bpt);
            this.myProcess.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> bpt.createRequest(this.myProcess));
        }
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint breakpoint, boolean temporary) {
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null) {
            this.myProcess.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> this.myProcess.getRequestsManager().deleteRequest(javaBreakpoint));
        }
    }

    public static class JavaFieldBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaFieldBreakpointHandler(DebugProcessImpl process2) {
            super(JavaFieldBreakpointType.class, process2);
        }
    }

    public static class JavaWildcardBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaWildcardBreakpointHandler(DebugProcessImpl process2) {
            super(JavaWildcardMethodBreakpointType.class, process2);
        }
    }

    public static class JavaMethodBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaMethodBreakpointHandler(DebugProcessImpl process2) {
            super(JavaMethodBreakpointType.class, process2);
        }
    }

    public static class JavaExceptionBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaExceptionBreakpointHandler(DebugProcessImpl process2) {
            super(JavaExceptionBreakpointType.class, process2);
        }
    }

    public static class JavaLineBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaLineBreakpointHandler(DebugProcessImpl process2) {
            super(JavaLineBreakpointType.class, process2);
        }
    }
}

