/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.StepIntoMethodBreakpoint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Range;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    private static final Logger LOG = Logger.getInstance(BasicStepMethodFilter.class);
    private static final String PROXY_CALL_SIGNATURE_POSTFIX = "Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String myTargetMethodName;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> myCallingExpressionLines;
    private final int myOrdinal;
    private final boolean myCheckCaller;

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, Range<Integer> callingExpressionLines) {
        this(psiMethod, 0, callingExpressionLines);
    }

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, int ordinal, Range<Integer> callingExpressionLines) {
        this(JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass()), JVMNameUtil.getJVMMethodName(psiMethod), JVMNameUtil.getJVMSignature(psiMethod), ordinal, callingExpressionLines, BasicStepMethodFilter.checkCaller(psiMethod));
    }

    protected BasicStepMethodFilter(@NotNull JVMName declaringClassName, @NotNull String targetMethodName, @Nullable JVMName targetMethodSignature, int ordinal, Range<Integer> callingExpressionLines, boolean checkCaller) {
        this.myDeclaringClassName = declaringClassName;
        this.myTargetMethodName = targetMethodName;
        this.myTargetMethodSignature = targetMethodSignature;
        this.myCallingExpressionLines = callingExpressionLines;
        this.myOrdinal = ordinal;
        this.myCheckCaller = checkCaller;
    }

    private static boolean checkCaller(PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        return aClass != null && aClass.hasAnnotation("java.lang.FunctionalInterface");
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.myTargetMethodName;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location) throws EvaluateException {
        return this.locationMatches(process2, location, null, false);
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location, @Nullable StackFrameProxyImpl frameProxy) throws EvaluateException {
        return this.locationMatches(process2, location, frameProxy, false);
    }

    private boolean locationMatches(DebugProcessImpl process2, Location location, @Nullable StackFrameProxyImpl stackFrame, boolean caller) throws EvaluateException {
        ObjectReference thisObject;
        Method method = location.method();
        String name2 = method.name();
        if (!this.myTargetMethodName.equals(name2)) {
            if (this.isLambdaCall(process2, name2, location)) {
                return true;
            }
            if (!caller && this.myCheckCaller) {
                int index = stackFrame.getFrameIndex();
                StackFrameProxyImpl callerFrame = stackFrame.threadProxy().frame(index + 1);
                if (callerFrame != null) {
                    return this.locationMatches(process2, callerFrame.location(), callerFrame, true);
                }
            }
            return false;
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.signatureMatches(method, this.myTargetMethodSignature.getName(process2))) {
            return false;
        }
        if (!caller && RequestHint.isProxyMethod(method)) {
            return false;
        }
        String declaringClassNameName = this.myDeclaringClassName.getName(process2);
        boolean res = DebuggerUtilsEx.isAssignableFrom(declaringClassNameName, location.declaringType());
        if (!res && !method.isStatic() && stackFrame != null && (thisObject = stackFrame.thisObject()) != null) {
            res = DebuggerUtilsEx.isAssignableFrom(declaringClassNameName, thisObject.referenceType());
        }
        return res;
    }

    private boolean isLambdaCall(DebugProcessImpl process2, String name2, Location location) {
        if (DebuggerUtilsEx.isLambdaName(name2)) {
            SourcePosition position = process2.getPositionManager().getSourcePosition(location);
            return (Boolean)ReadAction.compute(() -> {
                PsiElement psiMethod = DebuggerUtilsEx.getContainingMethod(position);
                if (psiMethod instanceof PsiLambdaExpression) {
                    PsiType type2 = ((PsiLambdaExpression)psiMethod).getFunctionalInterfaceType();
                    PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
                    if (type2 != null && interfaceMethod != null && this.myTargetMethodName.equals(interfaceMethod.getName())) {
                        try {
                            return InheritanceUtil.isInheritor((PsiType)type2, (String)this.myDeclaringClassName.getName(process2).replace('$', '.'));
                        }
                        catch (EvaluateException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                }
                return false;
            });
        }
        return false;
    }

    public boolean proxyCheck(Location location, SuspendContextImpl context, RequestHint hint) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isProxyCall(debugProcess, location.method(), context.getFrameProxy())) {
            if (!DebugProcessImpl.isPositionFiltered(location)) {
                return true;
            }
            try {
                StepIntoMethodBreakpoint breakpoint = new StepIntoMethodBreakpoint(this.myDeclaringClassName.getName(debugProcess), this.myTargetMethodName, this.myTargetMethodSignature != null ? this.myTargetMethodSignature.getName(debugProcess) : null, debugProcess.getProject());
                DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, breakpoint, hint, false);
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    private boolean isProxyCall(DebugProcessImpl process2, Method method, @Nullable StackFrameProxyImpl stackFrame) {
        try {
            String signature = method.signature();
            if (stackFrame != null && signature != null && signature.endsWith(PROXY_CALL_SIGNATURE_POSTFIX)) {
                Value methodValue;
                Type proxyType;
                Value proxyValue;
                List<Value> argumentValues;
                int size;
                ReferenceType type2;
                String methodName = method.name();
                boolean match = false;
                if ("invoke".equals(methodName) && (type2 = method.declaringType()) instanceof ClassType && ((ClassType)type2).interfaces().stream().map(ReferenceType::name).anyMatch("java.lang.reflect.InvocationHandler"::equals)) {
                    match = true;
                }
                if (DebuggerUtilsEx.isLambdaName(methodName)) {
                    match = true;
                } else {
                    ObjectReference thisObject = stackFrame.thisObject();
                    if (thisObject != null && StringUtil.containsIgnoreCase((String)thisObject.referenceType().name(), (String)"CGLIB")) {
                        match = true;
                    }
                }
                if (match && (size = (argumentValues = stackFrame.getArgumentValues()).size()) >= 3 && (proxyValue = argumentValues.get(size - 3)) != null && (proxyType = proxyValue.type()) instanceof ReferenceType && DebuggerUtilsEx.isAssignableFrom(this.myDeclaringClassName.getName(process2), proxyType) && (methodValue = argumentValues.get(size - 2)) instanceof ObjectReference) {
                    ReferenceType methodType = ((ObjectReference)methodValue).referenceType();
                    return this.myTargetMethodName.equals(((StringReference)((ObjectReference)methodValue).getValue(methodType.fieldByName("name"))).value());
                }
            }
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }

    private static boolean signatureMatches(Method method, String expectedSignature) throws EvaluateException {
        if (expectedSignature.equals(method.signature())) {
            return true;
        }
        for (Method candidate : method.declaringType().methodsByName(method.name())) {
            if (candidate == method || !candidate.isBridge() || !expectedSignature.equals(candidate.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @Override
    public int getSkipCount() {
        return this.myOrdinal;
    }
}

